;
; Movie player in PureBasic by AlphaSND
;
; Note: This source code is for demonstration only and is not
; finished or optimized at all. It has been coded in less than hour.
;
; Features:
;
; - Fast any movie replay (DirectShow), including AVI, MPG, etc..
; - Replay even MP3, Wav etc.. 
; - Volume and balance support
; - Fully resizeable !
; - Nice toolbar :)
;

If InitMovie() = 0
  MessageRequester("Error", "Can't initialize movie playback !", 0) 
  End
EndIf


If CreateMenu(0)
  MenuTitle("File")
    MenuItem(0, "Load Movie")
    MenuBar()
    MenuItem(1, "Quit")
    
  MenuTitle("Control")
    MenuItem(2, "Play")
    MenuItem(3, "Stop")
    MenuItem(4, "Pause")

    MenuBar()
    
    OpenSubMenu("Size")
      MenuItem(13, "50 %")
      MenuItem(14, "100 %")
      MenuItem(15, "200 %")
    CloseSubMenu()
    
    MenuBar()
    
    OpenSubMenu("Volume")
      MenuItem(6, "100 %")
      MenuItem(7, "50 %")
      MenuItem(8, "Mute")
    CloseSubMenu()
    
    OpenSubMenu("Balance")
      MenuItem( 9, "Middle")
      MenuItem(10, "Left")
      MenuItem(11, "Right")
    CloseSubMenu()
    
  MenuTitle("About") 
    MenuItem(12, "About")
EndIf


If CreateToolBar(0)
  ToolBarImageButton(0, LoadImage(0, "Icons\Load.ico"))
  ToolBarSeparator()
  ToolBarImageButton(3, LoadImage(0, "Icons\Stop.ico"))
  ToolBarImageButton(2, LoadImage(0, "Icons\Play.ico"))
  ToolBarImageButton(4, LoadImage(0, "Icons\Pause.ico"))
  ToolBarSeparator()
  ToolBarImageButton(12, LoadImage(0, "Icons\About.ico"))
EndIf

; Callback needed for realtime resizing (solid mode under Windows)...
;

DisableDebugger
Procedure.l WindowCallback(WindowID, Message, wParam, lParam)
  Shared MovieLoaded
 
  If Message = #WM_SIZE
    UpdateStatusBar(0)
    
    If MovieLoaded
      ResizeMovie(6, 30, WindowWidth()-20, WindowHeight()-100)
    EndIf
  EndIf
 
EndProcedure
EnableDebugger

#WindowWidth = 300
#WindowHeight = 92

If OpenWindow(0, 100, 100, #WindowWidth, #WindowHeight, #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_MaximizeGadget | #PB_Window_SizeGadget, "PureBasic Movie Player v1.0")
  
  AttachMenu(0, WindowID())
  AttachToolBar(0, WindowID())
  
  If CreateStatusBar(0, WindowID())
    AddStatusBarField(6000) ; Excessive value of 6000 pixels, to have a field which take all the window width !
    SetStatusBarText(0, 0, "Welcome !", 0)
  EndIf
  
  SetWindowCallback(@WindowCallback())
  
  Volume = 100
      
  Repeat
    Select WaitWindowEvent()
            
      Case #PB_EventMenu
      
        Select EventMenuID()
        
          Case 0 ; Load
            MovieName$ = OpenFileRequester("Choose the movie to play", "", "Movie/Audio files|*.avi;*.mpg;*.asf;*.mp3;*.wav|All Files|*.*", 0)
            If MovieName$
              If LoadMovie(0, MovieName$)
                MovieLoaded = 1 
                MovieState  = 0
                
                If MovieHeight() > 0  ; Not an audio only file..
                  ResizeWindow(MovieWidth()+20, MovieHeight()+100)
                Else
                  ResizeWindow(#WindowWidth, #WindowHeight)
                EndIf
                
                SetStatusBarText(0, 0, "Movie '"+MovieName$+"' loaded", 0)
              Else
                SetStatusBarText(0, 0, "Can't load the movie '"+MovieName$+"'", 0)
              EndIf
            EndIf
            
          Case 1 ; Quit
            End
            
          ; ---------------- Movie controls -------------------
            
          Case 2 ; Play
            
            If MovieLoaded
              If MovieState = 2
                ResumeMovie()
              Else
                PlayMovie(0, WindowID())
              EndIf
              
              SetStatusBarText(0, 0, "Playing...", 0)
              MovieState = 1  ; Playing
            EndIf
            
          Case 3 ; Stop
            If MovieLoaded And MovieState = 1
              StopMovie()
              MovieState = 3 ; Stopped
              SetStatusBarText(0, 0, "Movie stopped.", 0)
           EndIf
            
          Case 4 ; Pause
            If MovieLoaded And MovieState = 1
              PauseMovie() 
              MovieState = 2  ; Paused
              SetStatusBarText(0, 0, "Movie paused.", 0)
           EndIf
            
          ; ---------------- Volume -------------------
            
          Case 6 ; Volume 100%
            Volume = 100
            
          Case 7 ; Volume 50%
            Volume = 50
            
          Case 8 ; Volume 100%
            Volume = 0
            
          ; ---------------- Balance -------------------
                        
          Case 9  ; Balance middle
            Balance = 0
            
          Case 10 ; Balance left
            Balance = -100
            
          Case 11 ; Balance right
            Balance = 100
            
          ; ---------------- Size -------------------

          Case 13  ; Size 50%
            If MovieLoaded 
              MovieWidth  = MovieWidth()/2
              MovieHeight = MovieHeight()/2
            EndIf
            
          Case 14 ; Size 100%
            If MovieLoaded 
              MovieWidth  = MovieWidth()
              MovieHeight = MovieHeight()
            EndIf
                    
          Case 15 ; Size 200%
            If MovieLoaded 
              MovieWidth  = MovieWidth()*2
              MovieHeight = MovieHeight()*2
            EndIf
            
          ; ---------------- Misc -------------------
            
          Case 12 ; About
            MessageRequester("Info", "PureBasic Movie Player"+Chr(10)+Chr(10)+"http://www.purebasic.com", #MB_ICONINFORMATION)
        
        EndSelect
        
        If MovieLoaded
          If CurrentWidth <> MovieWidth Or CurrentHeight <> MovieHeight
            ResizeWindow(MovieWidth+20, MovieHeight+100)  ; Movie will be resized in the #PB_WindowSizeEvent
            
            CurrentWidth  = MovieWidth
            CurrentHeight = MovieHeight
          EndIf
        
          If CurrentVolume <> Volume Or CurrentBalance <> Balance  ; We need to update the audio stuff
            MovieAudio(Volume, Balance)
            
            CurrentVolume  = Volume
            CurrentBalance = Balance
          EndIf
        EndIf
        
      Case #PB_EventCloseWindow
        End
        
    EndSelect

  ForEver    
EndIf

End 
; ExecutableFormat=Windows
; UseIcon=MoviePlayer.ico
; Executable=C:\Programmation\Projets\MoviePlayer\MoviePlayer.exe