;***************************************************************************
;*
;*  File:       ddraw.pb / DirectX 7 SDK
;*  Content:    DirectDraw include file
;*              for PureBasic (www.PureBasic.com)
;*  Autor:      Danilo, March 2002
;*
;***************************************************************************



Structure GUID
   Data1.l
   Data2.w
   Data3.w
   Data4.b[8]
EndStructure



;* Generic pixel format with 8-bit RGB and alpha components
Structure DDARGB
   blue.b
   green.b
   red.b
   alpha.b
EndStructure



;* This version of the structure remains for backwards source compatibility.
;* The DDARGB structure is the one that should be used for all DirectDraw APIs.
Structure DDRGBA
   red.b
   green.b
   blue.b
   alpha.b
EndStructure



;* DDCOLORKEY
Structure DDCOLORKEY
   dwColorSpaceLowValue.l  ;// low boundary of color space that is to
                           ;// be treated as Color Key, inclusive
   dwColorSpaceHighValue.l ;// high boundary of color space that is
                           ;// to be treated as Color Key, inclusive
EndStructure



;* DDSCAPS
Structure DDSCAPS
   dwCaps.l                ;// capabilities of surface wanted
EndStructure



;* DDOSCAPS
Structure DDOSCAPS
   dwCaps.l                ;// capabilities of surface wanted
EndStructure



;* This structure is used internally by DirectDraw.
Structure DDSCAPSEX
   dwCaps2.l
   dwCaps3.l
   dwCaps4.l
EndStructure



;* DDSCAPS2
Structure DDSCAPS2
   dwCaps.l                ;// capabilities of surface wanted
   dwCaps2.l
   dwCaps3.l
   dwCaps4.l
EndStructure



;* DDGAMMARAMP
Structure DDGAMMARAMP
   red.w[256]
   green.w[256]
   blue.w[256]
EndStructure



;* DDPIXELFORMAT
Structure DDPIXELFORMAT
   dwSize.l;                             // size of structure
   dwFlags.l;                            // pixel format flags
   dwFourCC.l;                           // (FOURCC code)

    StructureUnion
        dwRGBBitCount.l;                 // how many bits per pixel
        dwYUVBitCount.l;                 // how many bits per pixel
        dwZBufferBitDepth.l;             // how many total bits/pixel in z buffer (including any stencil bits)
        dwAlphaBitDepth.l;               // how many bits for alpha channels
        dwLuminanceBitCount.l;           // how many bits per pixel
        dwBumpBitCount.l;                // how many bits per "buxel", total
    EndStructureUnion

    StructureUnion
        dwRBitMask.l;                    // mask for red bit
        dwYBitMask.l;                    // mask for Y bits
        dwStencilBitDepth.l;             // how many stencil bits (note: dwZBufferBitDepth-dwStencilBitDepth is total Z-only bits)
        dwLuminanceBitMask.l;            // mask for luminance bits
        dwBumpDuBitMask.l;               // mask for bump map U delta bits
    EndStructureUnion

    StructureUnion
        dwGBitMask.l;                    // mask for green bits
        dwUBitMask.l;                    // mask for U bits
        dwZBitMask.l;                    // mask for Z bits
        dwBumpDvBitMask.l;               // mask for bump map V delta bits
    EndStructureUnion

    StructureUnion
        dwBBitMask.l;                    // mask for blue bits
        dwVBitMask.l;                    // mask for V bits
        dwStencilBitMask.l;              // mask for stencil bits
        dwBumpLuminanceBitMask.l;        // mask for luminance in bump map
    EndStructureUnion

    StructureUnion
        dwRGBAlphaBitMask.l;             // mask for alpha channel
        dwYUVAlphaBitMask.l;             // mask for alpha channel
        dwLuminanceAlphaBitMask.l;       // mask for alpha channel
        dwRGBZBitMask.l;                 // mask for Z channel
        dwYUVZBitMask.l;                 // mask for Z channel
    EndStructureUnion
EndStructure



;* DDSURFACEDESC
Structure DDSURFACEDESC
   dwSize.l;                                // size of the DDSURFACEDESC structure
   dwFlags.l;                               // determines what fields are valid
   dwHeight.l;                              // height of surface to be created
   dwWidth.l;                               // width of input surface
    StructureUnion
        lPitch.l;                           // distance to start of next line (return value only)
        dwLinearSize.l;                     // Formless late-allocated optimized surface size
    EndStructureUnion
   dwBackBufferCount.l;                     // number of back buffers requested
    StructureUnion
        dwMipMapCount.l;                    // number of mip-map levels requested
        dwZBufferBitDepth.l;                // depth of Z buffer requested
        dwRefreshRate.l;                    // refresh rate (used when display mode is described)
    EndStructureUnion
   dwAlphaBitDepth.l;                       // depth of alpha buffer requested
   dwReserved.l;                            // reserved
   lpSurface.l;                             // pointer to the associated surface memory
   ddckCKDestOverlay.DDCOLORKEY;            // color key for destination overlay use
   ddckCKDestBlt.DDCOLORKEY;                // color key for destination blt use
   ddckCKSrcOverlay.DDCOLORKEY;             // color key for source overlay use
   ddckCKSrcBlt.DDCOLORKEY;                 // color key for source blt use
   ddpfPixelFormat.DDPIXELFORMAT;           // pixel format description of the surface
   ddsCaps.DDSCAPS;                         // direct draw surface capabilities
EndStructure



;* DDSURFACEDESC2
Structure DDSURFACEDESC2
   dwSize.l;                                // size of the DDSURFACEDESC structure
   dwFlags.l;                               // determines what fields are valid
   dwHeight.l;                              // height of surface to be created
   dwWidth.l;                               // width of input surface
    StructureUnion
        lPitch.l;                           // distance to start of next line (return value only)
        dwLinearSize.l;                     // Formless late-allocated optimized surface size
    EndStructureUnion
   dwBackBufferCount.l;                     // number of back buffers requested
    StructureUnion
        dwMipMapCount.l;                    // number of mip-map levels requestde
        ;                                   // dwZBufferBitDepth removed, use ddpfPixelFormat one instead
        dwRefreshRate.l;                    // refresh rate (used when display mode is described)
        dwSrcVBHandle.l;                    // The source used in VB::Optimize
    EndStructureUnion
   dwAlphaBitDepth.l;                       // depth of alpha buffer requested
   dwReserved.l;                            // reserved
   lpSurface.l;                             // pointer to the associated surface memory
    StructureUnion
        ddckCKDestOverlay.DDCOLORKEY;       // color key for destination overlay use
        dwEmptyFaceColor.l;                 // Physical color for empty cubemap faces
    EndStructureUnion
   ddckCKDestBlt.DDCOLORKEY;                // color key for destination blt use
   ddckCKSrcOverlay.DDCOLORKEY;             // color key for source overlay use
   ddckCKSrcBlt.DDCOLORKEY;                 // color key for source blt use
    StructureUnion
        ddpfPixelFormat.DDPIXELFORMAT;      // pixel format description of the surface
        dwFVF.l;                            // vertex format description of vertex buffers
    EndStructureUnion
   ddsCaps.DDSCAPS2;                        // direct draw surface capabilities
   dwTextureStage.l;                        // stage in multitexture cascade
EndStructure


;*
;* USED FOR DIRECTDRAW Surface Description
;*
;*
;* ddsCaps field is valid.
;*
#DDSD_CAPS                    = $00000001     ;// default

;*
;* dwHeight field is valid.
;*
#DDSD_HEIGHT                  = $00000002

;*
;* dwWidth field is valid.
;*
#DDSD_WIDTH                   = $00000004

;*
;* lPitch is valid.
;*
#DDSD_PITCH                   = $00000008

;*
;* dwBackBufferCount is valid.
;*
#DDSD_BACKBUFFERCOUNT         = $00000020

;*
;* dwZBufferBitDepth is valid.  (shouldnt be used in DDSURFACEDESC2)
;*
#DDSD_ZBUFFERBITDEPTH         = $00000040

;*
;* dwAlphaBitDepth is valid.
;*
#DDSD_ALPHABITDEPTH           = $00000080

;*
;* lpSurface is valid.
;*
#DDSD_LPSURFACE               = $00000800

;*
;* ddpfPixelFormat is valid.
;*
#DDSD_PIXELFORMAT             = $00001000

;*
;* ddckCKDestOverlay is valid.
;*
#DDSD_CKDESTOVERLAY           = $00002000

;*
;* ddckCKDestBlt is valid.
;*
#DDSD_CKDESTBLT               = $00004000

;*
;* ddckCKSrcOverlay is valid.
;*
#DDSD_CKSRCOVERLAY            = $00008000

;*
;* ddckCKSrcBlt is valid.
;*
#DDSD_CKSRCBLT                = $00010000

;*
;* dwMipMapCount is valid.
;*
#DDSD_MIPMAPCOUNT             = $00020000

;*
;* dwRefreshRate is valid
;*
#DDSD_REFRESHRATE             = $00040000

;*
;* dwLinearSize is valid
;*
#DDSD_LINEARSIZE              = $00080000

;*
;* dwTextureStage is valid
;*
#DDSD_TEXTURESTAGE            = $00100000

;*
;* dwFVF is valid
;*
#DDSD_FVF                     = $00200000

;*
;* dwSrcVBHandle is valid
;*
#DDSD_SRCVBHANDLE             = $00400000

;*
;* All input fields are valid.
;*
#DDSD_ALL                     = $007ff9ee



;*
;* DDCAPS
;*
#DD_ROP_SPACE = (256/32)                ;// space required to store ROP array
;*
;* NOTE: Our choosen structure number scheme is to append a single digit to
;* the end of the structure giving the version that structure is associated
;* with.
;*
;*
;* This structure represents the DDCAPS structure released in DirectDraw 1.0.  It is used internally
;* by DirectDraw to interpret caps passed into ddraw by drivers written prior to the release of DirectDraw 2.0.
;* New applications should use the DDCAPS structure defined below.
;*
;#if DIRECTDRAW_VERSION <= 0x300
;    typedef DDCAPS_DX3 DDCAPS;
;#elif DIRECTDRAW_VERSION <= 0x500
;    typedef DDCAPS_DX5 DDCAPS;
;#elif DIRECTDRAW_VERSION <= 0x600
;    typedef DDCAPS_DX6 DDCAPS;
;#else
;    typedef DDCAPS_DX7 DDCAPS;
;#endif
;
;typedef DDCAPS FAR* LPDDCAPS;

Structure DDCAPS
   dwSize.l;                                  /*  0*/ DWORD      // size of the DDDRIVERCAPS structure
   dwCaps.l;                                  /*  4*/ DWORD      // driver specific capabilities
   dwCaps2.l;                                 /*  8*/ DWORD      // more driver specific capabilites
   dwCKeyCaps.l;                              /*  c*/ DWORD      // color key capabilities of the surface
   dwFXCaps.l;                                /* 10*/ DWORD      // driver specific stretching and effects capabilites
   dwFXAlphaCaps.l;                           /* 14*/ DWORD      // alpha driver specific capabilities
   dwPalCaps.l;                               /* 18*/ DWORD      // palette capabilities
   dwSVCaps.l;                                /* 1c*/ DWORD      // stereo vision capabilities
   dwAlphaBltConstBitDepths.l;                /* 20*/ DWORD      // DDBD_2,4,8
   dwAlphaBltPixelBitDepths.l;                /* 24*/ DWORD      // DDBD_1,2,4,8
   dwAlphaBltSurfaceBitDepths.l;              /* 28*/ DWORD      // DDBD_1,2,4,8
   dwAlphaOverlayConstBitDepths.l;            /* 2c*/ DWORD      // DDBD_2,4,8
   dwAlphaOverlayPixelBitDepths.l;            /* 30*/ DWORD      // DDBD_1,2,4,8
   dwAlphaOverlaySurfaceBitDepths.l;          /* 34*/ DWORD      // DDBD_1,2,4,8
   dwZBufferBitDepths.l;                      /* 38*/ DWORD      // DDBD_8,16,24,32
   dwVidMemTotal.l;                           /* 3c*/ DWORD      // total amount of video memory
   dwVidMemFree.l;                            /* 40*/ DWORD      // amount of free video memory
   dwMaxVisibleOverlays.l;                    /* 44*/ DWORD      // maximum number of visible overlays
   dwCurrVisibleOverlays.l;                   /* 48*/ DWORD      // current number of visible overlays
   dwNumFourCCCodes.l;                        /* 4c*/ DWORD      // number of four cc codes
   dwAlignBoundarySrc.l;                      /* 50*/ DWORD      // source rectangle alignment
   dwAlignSizeSrc.l;                          /* 54*/ DWORD      // source rectangle byte size
   dwAlignBoundaryDest.l;                     /* 58*/ DWORD      // dest rectangle alignment
   dwAlignSizeDest.l;                         /* 5c*/ DWORD      // dest rectangle byte size
   dwAlignStrideAlign.l;                      /* 60*/ DWORD      // stride alignment
   dwRops.l[#DD_ROP_SPACE];                   /* 64*/ DWORD      // ROPS supported
   ddsOldCaps.DDSCAPS;                        /* 84*/ DDSCAPS    // Was DDSCAPS  ddsCaps. ddsCaps is of type DDSCAPS2 for DX6
   dwMinOverlayStretch.l;                     /* 88*/ DWORD      // minimum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
   dwMaxOverlayStretch.l;                     /* 8c*/ DWORD      // maximum overlay stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
   dwMinLiveVideoStretch.l;                   /* 90*/ DWORD      // minimum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
   dwMaxLiveVideoStretch.l;                   /* 94*/ DWORD      // maximum live video stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
   dwMinHwCodecStretch.l;                     /* 98*/ DWORD      // minimum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
   dwMaxHwCodecStretch.l;                     /* 9c*/ DWORD      // maximum hardware codec stretch factor multiplied by 1000, eg 1000 == 1.0, 1300 == 1.3
   dwReserved1.l;                             /* a0*/ DWORD      // reserved
   dwReserved2.l;                             /* a4*/ DWORD      // reserved
   dwReserved3.l;                             /* a8*/ DWORD      // reserved
;// Members added for DX3:
   dwSVBCaps.l;                               /* ac*/ DWORD      // driver specific capabilities for System->Vmem blts
   dwSVBCKeyCaps.l;                           /* b0*/ DWORD      // driver color key capabilities for System->Vmem blts
   dwSVBFXCaps.l;                             /* b4*/ DWORD      // driver FX capabilities for System->Vmem blts
   dwSVBRops.l[#DD_ROP_SPACE];                /* b8*/ DWORD      // ROPS supported for System->Vmem blts
   dwVSBCaps.l;                               /* d8*/ DWORD      // driver specific capabilities for Vmem->System blts
   dwVSBCKeyCaps.l;                           /* dc*/ DWORD      // driver color key capabilities for Vmem->System blts
   dwVSBFXCaps.l;                             /* e0*/ DWORD      // driver FX capabilities for Vmem->System blts
   dwVSBRops.l[#DD_ROP_SPACE];                /* e4*/ DWORD      // ROPS supported for Vmem->System blts
   dwSSBCaps.l;                               /*104*/ DWORD      // driver specific capabilities for System->System blts
   dwSSBCKeyCaps.l;                           /*108*/ DWORD      // driver color key capabilities for System->System blts
   dwSSBFXCaps.l;                             /*10c*/ DWORD      // driver FX capabilities for System->System blts
   dwSSBRops.l[#DD_ROP_SPACE];                /*110*/ DWORD      // ROPS supported for System->System blts
;// Members added for DX5:
   dwMaxVideoPorts.l;                         /*130*/ DWORD      // maximum number of usable video ports
   dwCurrVideoPorts.l;                        /*134*/ DWORD      // current number of video ports used
   dwSVBCaps2.l;                              /*138*/ DWORD      // more driver specific capabilities for System->Vmem blts
   dwNLVBCaps.l;                              /*13c*/ DWORD      // driver specific capabilities for non-local->local vidmem blts
   dwNLVBCaps2.l;                             /*140*/ DWORD      // more driver specific capabilities non-local->local vidmem blts
   dwNLVBCKeyCaps.l;                          /*144*/ DWORD      // driver color key capabilities for non-local->local vidmem blts
   dwNLVBFXCaps.l;                            /*148*/ DWORD      // driver FX capabilities for non-local->local blts
   dwNLVBRops.l[#DD_ROP_SPACE];               /*14c*/ DWORD      // ROPS supported for non-local->local blts
;// Members added for DX6 release
   ddsCaps.DDSCAPS2;                          /*16c*/ DDSCAPS2   // Surface Caps
EndStructure



;*
;* DDOPTSURFACEDESC
;*
Structure DDOPTSURFACEDESC
   dwSize.l;             // size of the DDOPTSURFACEDESC structure
   dwFlags.l;            // determines what fields are valid
   ddSCaps.DDSCAPS2;     // Common caps like: Memory type
   ddOSCaps.DDOSCAPS;    // Common caps like: Memory type
   guid.GUID;            // Compression technique GUID
   dwCompressionRatio.l; // Compression ratio
EndStructure

;*
;* guid field is valid.
;*
#DDOSD_GUID                         = $00000001

;*
;* dwCompressionRatio field is valid.
;*
#DDOSD_COMPRESSION_RATIO            = $00000002

;*
;* ddSCaps field is valid.
;*
#DDOSD_SCAPS                        = $00000004

;*
;* ddOSCaps field is valid.
;*
#DDOSD_OSCAPS                       = $00000008

;*
;* All input fields are valid.
;*
#DDOSD_ALL                          = $0000000f

;*
;* The surface's optimized pixelformat is compressed
;*
#DDOSDCAPS_OPTCOMPRESSED            = $00000001

;*
;* The surface's optimized pixelformat is reordered
;*
#DDOSDCAPS_OPTREORDERED             = $00000002

;*
;* The opt surface is a monolithic mipmap
;*
#DDOSDCAPS_MONOLITHICMIPMAP         = $00000004

;*
;* The valid Surf caps:
;* #define DDSCAPS_SYSTEMMEMORY         0x00000800l
;* #define DDSCAPS_VIDEOMEMORY          0x00004000l
;* #define DDSCAPS_LOCALVIDMEM          0x10000000l
;* #define DDSCAPS_NONLOCALVIDMEM       0x20000000l
;*
#DDOSDCAPS_VALIDSCAPS               = $30004800

;*
;* The valid OptSurf caps
;*
#DDOSDCAPS_VALIDOSCAPS              = $00000007



;*
;* DDCOLORCONTROL
;*
Structure DDCOLORCONTROL
   dwSize.l;
   dwFlags.l;
   lBrightness.l;
   lContrast.l;
   lHue.l;
   lSaturation.l;
   lSharpness.l;
   lGamma.l;
   lColorEnable.l;
   dwReserved1.l;
EndStructure

;*
;* lBrightness field is valid.
;*
#DDCOLOR_BRIGHTNESS                   = $00000001

;*
;* lContrast field is valid.
;*
#DDCOLOR_CONTRAST                     = $00000002

;*
;* lHue field is valid.
;*
#DDCOLOR_HUE                          = $00000004

;*
;* lSaturation field is valid.
;*
#DDCOLOR_SATURATION                   = $00000008

;*
;* lSharpness field is valid.
;*
#DDCOLOR_SHARPNESS                    = $00000010

;*
;* lGamma field is valid.
;*
#DDCOLOR_GAMMA                        = $00000020

;*
;* lColorEnable field is valid.
;*
#DDCOLOR_COLORENABLE                  = $00000040



;*============================================================================
;*
;* Direct Draw Capability Flags
;*
;* These flags are used to describe the capabilities of a given Surface.
;* All flags are bit flags.
;*
;*============================================================================
;
;****************************************************************************
;*
;* DIRECTDRAWSURFACE CAPABILITY FLAGS
;*
;****************************************************************************

;*
;* This bit is reserved. It should not be specified.
;*
#DDSCAPS_RESERVED1                            = $00000001

;*
;* Indicates that this surface contains alpha-only information.
;* (To determine if a surface is RGBA/YUVA, the pixel format must be
;* interrogated.)
;*
#DDSCAPS_ALPHA                                = $00000002

;*
;* Indicates that this surface is a backbuffer.  It is generally
;* set by CreateSurface when the DDSCAPS_FLIP capability bit is set.
;* It indicates that this surface is THE back buffer of a surface
;* flipping structure.  DirectDraw supports N surfaces in a
;* surface flipping structure.  Only the surface that immediately
;* precedeces the DDSCAPS_FRONTBUFFER has this capability bit set.
;* The other surfaces are identified as back buffers by the presence
;* of the DDSCAPS_FLIP capability, their attachment order, and the
;* absence of the DDSCAPS_FRONTBUFFER and DDSCAPS_BACKBUFFER
;* capabilities.  The bit is sent to CreateSurface when a standalone
;* back buffer is being created.  This surface could be attached to
;* a front buffer and/or back buffers to form a flipping surface
;* structure after the CreateSurface call.  See AddAttachments for
;* a detailed description of the behaviors in this case.
;*
#DDSCAPS_BACKBUFFER                           = $00000004

;*
;* Indicates a complex surface structure is being described.  A
;* complex surface structure results in the creation of more than
;* one surface.  The additional surfaces are attached to the root
;* surface.  The complex structure can only be destroyed by
;* destroying the root.
;*
#DDSCAPS_COMPLEX                              = $00000008

;*
;* Indicates that this surface is a part of a surface flipping structure.
;* When it is passed to CreateSurface the DDSCAPS_FRONTBUFFER and
;* DDSCAP_BACKBUFFER bits are not set.  They are set by CreateSurface
;* on the resulting creations.  The dwBackBufferCount field in the
;* DDSURFACEDESC structure must be set to at least 1 in order for
;* the CreateSurface call to succeed.  The DDSCAPS_COMPLEX capability
;* must always be set with creating multiple surfaces through CreateSurface.
;*
#DDSCAPS_FLIP                                 = $00000010

;*
;* Indicates that this surface is THE front buffer of a surface flipping
;* structure.  It is generally set by CreateSurface when the DDSCAPS_FLIP
;* capability bit is set.
;* If this capability is sent to CreateSurface then a standalonw front buffer
;* is created.  This surface will not have the DDSCAPS_FLIP capability.
;* It can be attached to other back buffers to form a flipping structure.
;* See AddAttachments for a detailed description of the behaviors in this
;* case.
;*
#DDSCAPS_FRONTBUFFER                          = $00000020

;*
;* Indicates that this surface is any offscreen surface that is not an overlay,
;* texture, zbuffer, front buffer, back buffer, or alpha surface.  It is used
;* to identify plain vanilla surfaces.
;*
#DDSCAPS_OFFSCREENPLAIN                       = $00000040

;*
;* Indicates that this surface is an overlay.  It may or may not be directly visible
;* depending on whether or not it is currently being overlayed onto the primary
;* surface.  DDSCAPS_VISIBLE can be used to determine whether or not it is being
;* overlayed at the moment.
;*
#DDSCAPS_OVERLAY                              = $00000080

;*
;* Indicates that unique DirectDrawPalette objects can be created and
;* attached to this surface.
;*
#DDSCAPS_PALETTE                              = $00000100

;*
;* Indicates that this surface is the primary surface.  The primary
;* surface represents what the user is seeing at the moment.
;*
#DDSCAPS_PRIMARYSURFACE                       = $00000200

;*
;* This flag used to be DDSCAPS_PRIMARYSURFACELEFT, which is now
;* obsolete.
;*
#DDSCAPS_RESERVED3                            = $00000400

;*
;* Indicates that this surface memory was allocated in system memory
;*
#DDSCAPS_SYSTEMMEMORY                         = $00000800

;*
;* Indicates that this surface can be used as a 3D texture.  It does not
;* indicate whether or not the surface is being used for that purpose.
;*
#DDSCAPS_TEXTURE                              = $00001000

;*
;* Indicates that a surface may be a destination for 3D rendering.  This
;* bit must be set in order to query for a Direct3D Device Interface
;* from this surface.
;*
#DDSCAPS_3DDEVICE                             = $00002000

;*
;* Indicates that this surface exists in video memory.
;*
#DDSCAPS_VIDEOMEMORY                          = $00004000

;*
;* Indicates that changes made to this surface are immediately visible.
;* It is always set for the primary surface and is set for overlays while
;* they are being overlayed and texture maps while they are being textured.
;*
#DDSCAPS_VISIBLE                              = $00008000

;*
;* Indicates that only writes are permitted to the surface.  Read accesses
;* from the surface may or may not generate a protection fault, but the
;* results of a read from this surface will not be meaningful.  READ ONLY.
;*
#DDSCAPS_WRITEONLY                            = $00010000

;*
;* Indicates that this surface is a z buffer. A z buffer does not contain
;* displayable information.  Instead it contains bit depth information that is
;* used to determine which pixels are visible and which are obscured.
;*
#DDSCAPS_ZBUFFER                              = $00020000

;*
;* Indicates surface will have a DC associated long term
;*
#DDSCAPS_OWNDC                                = $00040000

;*
;* Indicates surface should be able to receive live video
;*
#DDSCAPS_LIVEVIDEO                            = $00080000

;*
;* Indicates surface should be able to have a stream decompressed
;* to it by the hardware.
;*
#DDSCAPS_HWCODEC                              = $00100000

;*
;* Surface is a ModeX surface.
;*
;*
#DDSCAPS_MODEX                                = $00200000

;*
;* Indicates surface is one level of a mip-map. This surface will
;* be attached to other DDSCAPS_MIPMAP surfaces to form the mip-map.
;* This can be done explicitly, by creating a number of surfaces and
;* attaching them with AddAttachedSurface or by implicitly by CreateSurface.
;* If this bit is set then DDSCAPS_TEXTURE must also be set.
;*
#DDSCAPS_MIPMAP                               = $00400000

;*
;* This bit is reserved. It should not be specified.
;*
#DDSCAPS_RESERVED2                            = $00800000

;*
;* Indicates that memory for the surface is not allocated until the surface
;* is loaded (via the Direct3D texture Load() function).
;*
#DDSCAPS_ALLOCONLOAD                          = $04000000

;*
;* Indicates that the surface will recieve data from a video port.
;*
#DDSCAPS_VIDEOPORT                            = $08000000

;*
;* Indicates that a video memory surface is resident in true, local video
;* memory rather than non-local video memory. If this flag is specified then
;* so must DDSCAPS_VIDEOMEMORY. This flag is mutually exclusive with
;* DDSCAPS_NONLOCALVIDMEM.
;*
#DDSCAPS_LOCALVIDMEM                          = $10000000

;*
;* Indicates that a video memory surface is resident in non-local video
;* memory rather than true, local video memory. If this flag is specified
;* then so must DDSCAPS_VIDEOMEMORY. This flag is mutually exclusive with
;* DDSCAPS_LOCALVIDMEM.
;*
#DDSCAPS_NONLOCALVIDMEM                       = $20000000

;*
;* Indicates that this surface is a standard VGA mode surface, and not a
;* ModeX surface. (This flag will never be set in combination with the
;* DDSCAPS_MODEX flag).
;*
#DDSCAPS_STANDARDVGAMODE                      = $40000000

;*
;* Indicates that this surface will be an optimized surface. This flag is
;* currently only valid in conjunction with the DDSCAPS_TEXTURE flag. The surface
;* will be created without any underlying video memory until loaded.
;*
#DDSCAPS_OPTIMIZED                            = $80000000

;*
;* Indicates that this surface will receive data from a video port using
;* the de-interlacing hardware.  This allows the driver to allocate memory
;* for any extra buffers that may be required.  The DDSCAPS_VIDEOPORT and
;* DDSCAPS_OVERLAY flags must also be set.
;*
#DDSCAPS2_HARDWAREDEINTERLACE                 = $00000002

;*
;* Indicates to the driver that this surface will be locked very frequently
;* (for procedural textures, dynamic lightmaps, etc). Surfaces with this cap
;* set must also have DDSCAPS_TEXTURE. This cap cannot be used with
;* DDSCAPS2_HINTSTATIC and DDSCAPS2_OPAQUE.
;*
#DDSCAPS2_HINTDYNAMIC                         = $00000004

;*
;* Indicates to the driver that this surface can be re-ordered/retiled on
;* load. This operation will not change the size of the texture. It is
;* relatively fast and symmetrical, since the application may lock these
;* bits (although it will take a performance hit when doing so). Surfaces
;* with this cap set must also have DDSCAPS_TEXTURE. This cap cannot be
;* used with DDSCAPS2_HINTDYNAMIC and DDSCAPS2_OPAQUE.
;*
#DDSCAPS2_HINTSTATIC                          = $00000008

;*
;* Indicates that the client would like this texture surface to be managed by the
;* DirectDraw/Direct3D runtime. Surfaces with this cap set must also have
;* DDSCAPS_TEXTURE set.
;*
#DDSCAPS2_TEXTUREMANAGE                       = $00000010

;*
;* These bits are reserved for internal use */
#DDSCAPS2_RESERVED1                           = $00000020
#DDSCAPS2_RESERVED2                           = $00000040

;*
;* Indicates to the driver that this surface will never be locked again.
;* The driver is free to optimize this surface via retiling and actual compression.
;* All calls to Lock() or Blts from this surface will fail. Surfaces with this
;* cap set must also have DDSCAPS_TEXTURE. This cap cannot be used with
;* DDSCAPS2_HINTDYNAMIC and DDSCAPS2_HINTSTATIC.
;*
#DDSCAPS2_OPAQUE                              = $00000080

;*
;* Applications should set this bit at CreateSurface time to indicate that they
;* intend to use antialiasing. Only valid if DDSCAPS_3DDEVICE is also set.
;*
#DDSCAPS2_HINTANTIALIASING                    = $00000100

;*
;* This flag is used at CreateSurface time to indicate that this set of
;* surfaces is a cubic environment map
;*
#DDSCAPS2_CUBEMAP                             = $00000200

;*
;* These flags preform two functions:
;* - At CreateSurface time, they define which of the six cube faces are
;*   required by the application.
;* - After creation, each face in the cubemap will have exactly one of these
;*   bits set.
;*
#DDSCAPS2_CUBEMAP_POSITIVEX                   = $00000400
#DDSCAPS2_CUBEMAP_NEGATIVEX                   = $00000800
#DDSCAPS2_CUBEMAP_POSITIVEY                   = $00001000
#DDSCAPS2_CUBEMAP_NEGATIVEY                   = $00002000
#DDSCAPS2_CUBEMAP_POSITIVEZ                   = $00004000
#DDSCAPS2_CUBEMAP_NEGATIVEZ                   = $00008000

;*
;* This macro may be used to specify all faces of a cube map at CreateSurface time
;*
#DDSCAPS2_CUBEMAP_ALLFACES                    = ( #DDSCAPS2_CUBEMAP_POSITIVEX | #DDSCAPS2_CUBEMAP_NEGATIVEX | #DDSCAPS2_CUBEMAP_POSITIVEY | #DDSCAPS2_CUBEMAP_NEGATIVEY | #DDSCAPS2_CUBEMAP_POSITIVEZ | #DDSCAPS2_CUBEMAP_NEGATIVEZ )

;*
;* This flag is an additional flag which is present on mipmap sublevels from DX7 onwards
;* It enables easier use of GetAttachedSurface rather than EnumAttachedSurfaces for surface
;* constructs such as Cube Maps, wherein there are more than one mipmap surface attached
;* to the root surface.
;* This caps bit is ignored by CreateSurface
;*
#DDSCAPS2_MIPMAPSUBLEVEL                      = $00010000

;* This flag indicates that the texture should be managed by D3D only */
#DDSCAPS2_D3DTEXTUREMANAGE                    = $00020000

;* This flag indicates that the managed surface can be safely lost */
#DDSCAPS2_DONOTPERSIST                        = $00040000

;* indicates that this surface is part of a stereo flipping chain */
#DDSCAPS2_STEREOSURFACELEFT                   = $00080000



;****************************************************************************
;*
;* DIRECTDRAW DRIVER CAPABILITY FLAGS
;*
;****************************************************************************

;*
;* Display hardware has 3D acceleration.
;*
#DDCAPS_3D                                        = $00000001

;*
;* Indicates that DirectDraw will support only dest rectangles that are aligned
;* on DIRECTDRAWCAPS.dwAlignBoundaryDest boundaries of the surface, respectively.
;* READ ONLY.
;*
#DDCAPS_ALIGNBOUNDARYDEST                         = $00000002

;*
;* Indicates that DirectDraw will support only source rectangles  whose sizes in
;* BYTEs are DIRECTDRAWCAPS.dwAlignSizeDest multiples, respectively.  READ ONLY.
;*
#DDCAPS_ALIGNSIZEDEST                             = $00000004

;*
;* Indicates that DirectDraw will support only source rectangles that are aligned
;* on DIRECTDRAWCAPS.dwAlignBoundarySrc boundaries of the surface, respectively.
;* READ ONLY.
;*
#DDCAPS_ALIGNBOUNDARYSRC                          = $00000008

;*
;* Indicates that DirectDraw will support only source rectangles  whose sizes in
;* BYTEs are DIRECTDRAWCAPS.dwAlignSizeSrc multiples, respectively.  READ ONLY.
;*
#DDCAPS_ALIGNSIZESRC                              = $00000010

;*
;* Indicates that DirectDraw will create video memory surfaces that have a stride
;* alignment equal to DIRECTDRAWCAPS.dwAlignStride.  READ ONLY.
;*
#DDCAPS_ALIGNSTRIDE                               = $00000020

;*
;* Display hardware is capable of blt operations.
;*
#DDCAPS_BLT                                       = $00000040

;*
;* Display hardware is capable of asynchronous blt operations.
;*
#DDCAPS_BLTQUEUE                                  = $00000080

;*
;* Display hardware is capable of color space conversions during the blt operation.
;*
#DDCAPS_BLTFOURCC                                 = $00000100

;*
;* Display hardware is capable of stretching during blt operations.
;*
#DDCAPS_BLTSTRETCH                                = $00000200

;*
;* Display hardware is shared with GDI.
;*
#DDCAPS_GDI                                       = $00000400

;*
;* Display hardware can overlay.
;*
#DDCAPS_OVERLAY                                   = $00000800

;*
;* Set if display hardware supports overlays but can not clip them.
;*
#DDCAPS_OVERLAYCANTCLIP                           = $00001000

;*
;* Indicates that overlay hardware is capable of color space conversions during
;* the overlay operation.
;*
#DDCAPS_OVERLAYFOURCC                             = $00002000

;*
;* Indicates that stretching can be done by the overlay hardware.
;*
#DDCAPS_OVERLAYSTRETCH                            = $00004000

;*
;* Indicates that unique DirectDrawPalettes can be created for DirectDrawSurfaces
;* other than the primary surface.
;*
#DDCAPS_PALETTE                                   = $00008000

;*
;* Indicates that palette changes can be syncd with the veritcal refresh.
;*
#DDCAPS_PALETTEVSYNC                              = $00010000

;*
;* Display hardware can return the current scan line.
;*
#DDCAPS_READSCANLINE                              = $00020000

;*
;* This flag used to bo DDCAPS_STEREOVIEW, which is now obsolete
;*
#DDCAPS_RESERVED1                                 = $00040000

;*
;* Display hardware is capable of generating a vertical blank interrupt.
;*
#DDCAPS_VBI                                       = $00080000

;*
;* Supports the use of z buffers with blt operations.
;*
#DDCAPS_ZBLTS                                     = $00100000

;*
;* Supports Z Ordering of overlays.
;*
#DDCAPS_ZOVERLAYS                                 = $00200000

;*
;* Supports color key
;*
#DDCAPS_COLORKEY                                  = $00400000

;*
;* Supports alpha surfaces
;*
#DDCAPS_ALPHA                                     = $00800000

;*
;* colorkey is hardware assisted(DDCAPS_COLORKEY will also be set)
;*
#DDCAPS_COLORKEYHWASSIST                          = $01000000

;*
;* no hardware support at all
;*
#DDCAPS_NOHARDWARE                                = $02000000

;*
;* Display hardware is capable of color fill with bltter
;*
#DDCAPS_BLTCOLORFILL                              = $04000000

;*
;* Display hardware is bank switched, and potentially very slow at
;* random access to VRAM.
;*
#DDCAPS_BANKSWITCHED                              = $08000000

;*
;* Display hardware is capable of depth filling Z-buffers with bltter
;*
#DDCAPS_BLTDEPTHFILL                              = $10000000

;*
;* Display hardware is capable of clipping while bltting.
;*
#DDCAPS_CANCLIP                                   = $20000000

;*
;* Display hardware is capable of clipping while stretch bltting.
;*
#DDCAPS_CANCLIPSTRETCHED                          = $40000000

;*
;* Display hardware is capable of bltting to or from system memory
;*
#DDCAPS_CANBLTSYSMEM                              = $80000000



;****************************************************************************
;*
;* MORE DIRECTDRAW DRIVER CAPABILITY FLAGS (dwCaps2)
;*
;****************************************************************************

;*
;* Display hardware is certified
;*
#DDCAPS2_CERTIFIED                                = $00000001

;*
;* Driver cannot interleave 2D operations (lock and blt) to surfaces with
;* Direct3D rendering operations between calls to BeginScene() and EndScene()
;*
#DDCAPS2_NO2DDURING3DSCENE                        = $00000002

;*
;* Display hardware contains a video port
;*
#DDCAPS2_VIDEOPORT                                = $00000004

;*
;* The overlay can be automatically flipped according to the video port
;* VSYNCs, providing automatic doubled buffered display of video port
;* data using an overlay
;*
#DDCAPS2_AUTOFLIPOVERLAY                          = $00000008

;*
;* Overlay can display each field of interlaced data individually while
;* it is interleaved in memory without causing jittery artifacts.
;*
#DDCAPS2_CANBOBINTERLEAVED                        = $00000010

;*
;* Overlay can display each field of interlaced data individually while
;* it is not interleaved in memory without causing jittery artifacts.
;*
#DDCAPS2_CANBOBNONINTERLEAVED                     = $00000020

;*
;* The overlay surface contains color controls (brightness, sharpness, etc.)
;*
#DDCAPS2_COLORCONTROLOVERLAY                      = $00000040

;*
;* The primary surface contains color controls (gamma, etc.)
;*
#DDCAPS2_COLORCONTROLPRIMARY                      = $00000080

;*
;* RGBZ -> RGB supported for 16:16 RGB:Z
;*
#DDCAPS2_CANDROPZ16BIT                            = $00000100

;*
;* Driver supports non-local video memory.
;*
#DDCAPS2_NONLOCALVIDMEM                           = $00000200

;*
;* Dirver supports non-local video memory but has different capabilities for
;* non-local video memory surfaces. If this bit is set then so must
;* DDCAPS2_NONLOCALVIDMEM.
;*
#DDCAPS2_NONLOCALVIDMEMCAPS                       = $00000400

;*
;* Driver neither requires nor prefers surfaces to be pagelocked when performing
;* blts involving system memory surfaces
;*
#DDCAPS2_NOPAGELOCKREQUIRED                       = $00000800

;*
;* Driver can create surfaces which are wider than the primary surface
;*
#DDCAPS2_WIDESURFACES                             = $00001000

;*
;* Driver supports bob without using a video port by handling the
;* DDFLIP_ODD and DDFLIP_EVEN flags specified in Flip.
;*
#DDCAPS2_CANFLIPODDEVEN                           = $00002000

;*
;* Driver supports bob using hardware
;*
#DDCAPS2_CANBOBHARDWARE                           = $00004000

;*
;* Driver supports bltting any FOURCC surface to another surface of the same FOURCC
;*
#DDCAPS2_COPYFOURCC                               = $00008000

;*
;* Driver supports loadable gamma ramps for the primary surface
;*
#DDCAPS2_PRIMARYGAMMA                             = $00020000

;*
;* Driver can render in windowed mode.
;*
#DDCAPS2_CANRENDERWINDOWED                        = $00080000

;*
;* A calibrator is available to adjust the gamma ramp according to the
;* physical display properties so that the result will be identical on
;* all calibrated systems.
;*
#DDCAPS2_CANCALIBRATEGAMMA                        = $00100000

;*
;* Indicates that the driver will respond to DDFLIP_INTERVALn flags
;*
#DDCAPS2_FLIPINTERVAL                             = $00200000

;*
;* Indicates that the driver will respond to DDFLIP_NOVSYNC
;*
#DDCAPS2_FLIPNOVSYNC                              = $00400000

;*
;* Driver supports management of video memory, if this flag is ON,
;* driver manages the texture if requested with DDSCAPS2_TEXTUREMANAGE on
;* DirectX manages the texture if this flag is OFF and surface has DDSCAPS2_TEXTUREMANAGE on
;*
#DDCAPS2_CANMANAGETEXTURE                         = $00800000

;*
;* The Direct3D texture manager uses this cap to decide whether to put managed
;* surfaces in non-local video memory. If the cap is set, the texture manager will
;* put managed surfaces in non-local vidmem. Drivers that cannot texture from
;* local vidmem SHOULD NOT set this cap.
;*
#DDCAPS2_TEXMANINNONLOCALVIDMEM                   = $01000000

;*
;* Indicates that the driver supports DX7 type of stereo in at least one mode (which may
;* not necessarily be the current mode). Applications should use IDirectDraw7 (or higher)
;* ::EnumDisplayModes and check the DDSURFACEDESC.ddsCaps.dwCaps2 field for the presence of
;* DDSCAPS2_STEREOSURFACELEFT to check if a particular mode supports stereo. The application
;* can also use IDirectDraw7(or higher)::GetDisplayMode to check the current mode.
;*
#DDCAPS2_STEREO                                   = $02000000

;*
;* This caps bit is intended for internal DirectDraw use. 
;* -It is only valid if DDCAPS2_NONLOCALVIDMEMCAPS is set.
;* -If this bit is set, then DDCAPS_CANBLTSYSMEM MUST be set by the driver (and
;*  all the assoicated system memory blt caps must be correct).
;* -It implies that the system->video blt caps in DDCAPS also apply to system to 
;*  nonlocal blts. I.e. the dwSVBCaps, dwSVBCKeyCaps, dwSVBFXCaps and dwSVBRops
;*  members of DDCAPS (DDCORECAPS) are filled in correctly.
;* -Any blt from system to nonlocal memory that matches these caps bits will
;*  be passed to the driver.
;*
;* NOTE: This is intended to enable the driver itself to do efficient reordering
;* of textures. This is NOT meant to imply that hardware can write into AGP memory.
;* This operation is not currently supported.
;*
#DDCAPS2_SYSTONONLOCAL_AS_SYSTOLOCAL              = $04000000



;****************************************************************************
;*
;* DIRECTDRAW FX ALPHA CAPABILITY FLAGS
;*
;****************************************************************************

;*
;* Supports alpha blending around the edge of a source color keyed surface.
;* For Blt.
;*
#DDFXALPHACAPS_BLTALPHAEDGEBLEND                  = $00000001

;*
;* Supports alpha information in the pixel format.  The bit depth of alpha
;* information in the pixel format can be 1,2,4, or 8.  The alpha value becomes
;* more opaque as the alpha value increases.  (0 is transparent.)
;* For Blt.
;*
#DDFXALPHACAPS_BLTALPHAPIXELS                     = $00000002

;*
;* Supports alpha information in the pixel format.  The bit depth of alpha
;* information in the pixel format can be 1,2,4, or 8.  The alpha value
;* becomes more transparent as the alpha value increases.  (0 is opaque.)
;* This flag can only be set if DDCAPS_ALPHA is set.
;* For Blt.
;*
#DDFXALPHACAPS_BLTALPHAPIXELSNEG                  = $00000004

;*
;* Supports alpha only surfaces.  The bit depth of an alpha only surface can be
;* 1,2,4, or 8.  The alpha value becomes more opaque as the alpha value increases.
;* (0 is transparent.)
;* For Blt.
;*
#DDFXALPHACAPS_BLTALPHASURFACES                   = $00000008

;*
;* The depth of the alpha channel data can range can be 1,2,4, or 8.
;* The NEG suffix indicates that this alpha channel becomes more transparent
;* as the alpha value increases. (0 is opaque.)  This flag can only be set if
;* DDCAPS_ALPHA is set.
;* For Blt.
;*
#DDFXALPHACAPS_BLTALPHASURFACESNEG                = $00000010

;*
;* Supports alpha blending around the edge of a source color keyed surface.
;* For Overlays.
;*
#DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND              = $00000020

;*
;* Supports alpha information in the pixel format.  The bit depth of alpha
;* information in the pixel format can be 1,2,4, or 8.  The alpha value becomes
;* more opaque as the alpha value increases.  (0 is transparent.)
;* For Overlays.
;*
#DDFXALPHACAPS_OVERLAYALPHAPIXELS                 = $00000040

;*
;* Supports alpha information in the pixel format.  The bit depth of alpha
;* information in the pixel format can be 1,2,4, or 8.  The alpha value
;* becomes more transparent as the alpha value increases.  (0 is opaque.)
;* This flag can only be set if DDCAPS_ALPHA is set.
;* For Overlays.
;*
#DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG              = $00000080

;*
;* Supports alpha only surfaces.  The bit depth of an alpha only surface can be
;* 1,2,4, or 8.  The alpha value becomes more opaque as the alpha value increases.
;* (0 is transparent.)
;* For Overlays.
;*
#DDFXALPHACAPS_OVERLAYALPHASURFACES               = $00000100

;*
;* The depth of the alpha channel data can range can be 1,2,4, or 8.
;* The NEG suffix indicates that this alpha channel becomes more transparent
;* as the alpha value increases. (0 is opaque.)  This flag can only be set if
;* DDCAPS_ALPHA is set.
;* For Overlays.
;*
#DDFXALPHACAPS_OVERLAYALPHASURFACESNEG            = $00000200



;****************************************************************************
;*
;* DIRECTDRAW FX CAPABILITY FLAGS
;*
;****************************************************************************

;*
;* Uses arithmetic operations to stretch and shrink surfaces during blt
;* rather than pixel doubling techniques.  Along the Y axis.
;*
#DDFXCAPS_BLTARITHSTRETCHY                        = $00000020

;*
;* Uses arithmetic operations to stretch during blt
;* rather than pixel doubling techniques.  Along the Y axis. Only
;* works for x1, x2, etc.
;*
#DDFXCAPS_BLTARITHSTRETCHYN                       = $00000010

;*
;* Supports mirroring left to right in blt.
;*
#DDFXCAPS_BLTMIRRORLEFTRIGHT                      = $00000040

;*
;* Supports mirroring top to bottom in blt.
;*
#DDFXCAPS_BLTMIRRORUPDOWN                         = $00000080

;*
;* Supports arbitrary rotation for blts.
;*
#DDFXCAPS_BLTROTATION                             = $00000100

;*
;* Supports 90 degree rotations for blts.
;*
#DDFXCAPS_BLTROTATION90                           = $00000200

;*
;* DirectDraw supports arbitrary shrinking of a surface along the
;* x axis (horizontal direction) for blts.
;*
#DDFXCAPS_BLTSHRINKX                              = $00000400

;*
;* DirectDraw supports integer shrinking (1x,2x,) of a surface
;* along the x axis (horizontal direction) for blts.
;*
#DDFXCAPS_BLTSHRINKXN                             = $00000800

;*
;* DirectDraw supports arbitrary shrinking of a surface along the
;* y axis (horizontal direction) for blts.
;*
#DDFXCAPS_BLTSHRINKY                              = $00001000

;*
;* DirectDraw supports integer shrinking (1x,2x,) of a surface
;* along the y axis (vertical direction) for blts.
;*
#DDFXCAPS_BLTSHRINKYN                             = $00002000

;*
;* DirectDraw supports arbitrary stretching of a surface along the
;* x axis (horizontal direction) for blts.
;*
#DDFXCAPS_BLTSTRETCHX                             = $00004000

;*
;* DirectDraw supports integer stretching (1x,2x,) of a surface
;* along the x axis (horizontal direction) for blts.
;*
#DDFXCAPS_BLTSTRETCHXN                            = $00008000

;*
;* DirectDraw supports arbitrary stretching of a surface along the
;* y axis (horizontal direction) for blts.
;*
#DDFXCAPS_BLTSTRETCHY                             = $00010000

;*
;* DirectDraw supports integer stretching (1x,2x,) of a surface
;* along the y axis (vertical direction) for blts.
;*
#DDFXCAPS_BLTSTRETCHYN                            = $00020000

;*
;* Uses arithmetic operations to stretch and shrink surfaces during
;* overlay rather than pixel doubling techniques.  Along the Y axis
;* for overlays.
;*
#DDFXCAPS_OVERLAYARITHSTRETCHY                    = $00040000

;*
;* Uses arithmetic operations to stretch surfaces during
;* overlay rather than pixel doubling techniques.  Along the Y axis
;* for overlays. Only works for x1, x2, etc.
;*
#DDFXCAPS_OVERLAYARITHSTRETCHYN                   = $00000008

;*
;* DirectDraw supports arbitrary shrinking of a surface along the
;* x axis (horizontal direction) for overlays.
;*
#DDFXCAPS_OVERLAYSHRINKX                          = $00080000

;*
;* DirectDraw supports integer shrinking (1x,2x,) of a surface
;* along the x axis (horizontal direction) for overlays.
;*
#DDFXCAPS_OVERLAYSHRINKXN                         = $00100000

;*
;* DirectDraw supports arbitrary shrinking of a surface along the
;* y axis (horizontal direction) for overlays.
;*
#DDFXCAPS_OVERLAYSHRINKY                          = $00200000

;*
;* DirectDraw supports integer shrinking (1x,2x,) of a surface
;* along the y axis (vertical direction) for overlays.
;*
#DDFXCAPS_OVERLAYSHRINKYN                         = $00400000

;*
;* DirectDraw supports arbitrary stretching of a surface along the
;* x axis (horizontal direction) for overlays.
;*
#DDFXCAPS_OVERLAYSTRETCHX                         = $00800000

;*
;* DirectDraw supports integer stretching (1x,2x,) of a surface
;* along the x axis (horizontal direction) for overlays.
;*
#DDFXCAPS_OVERLAYSTRETCHXN                        = $01000000

;*
;* DirectDraw supports arbitrary stretching of a surface along the
;* y axis (horizontal direction) for overlays.
;*
#DDFXCAPS_OVERLAYSTRETCHY                         = $02000000

;*
;* DirectDraw supports integer stretching (1x,2x,) of a surface
;* along the y axis (vertical direction) for overlays.
;*
#DDFXCAPS_OVERLAYSTRETCHYN                        = $04000000

;*
;* DirectDraw supports mirroring of overlays across the vertical axis
;*
#DDFXCAPS_OVERLAYMIRRORLEFTRIGHT                  = $08000000

;*
;* DirectDraw supports mirroring of overlays across the horizontal axis
;*
#DDFXCAPS_OVERLAYMIRRORUPDOWN                     = $10000000

;*
;* Driver can do alpha blending for blits.
;*
#DDFXCAPS_BLTALPHA                                = $00000001

;*
;* Driver can do surface-reconstruction filtering for warped blits.
;*
#DDFXCAPS_BLTFILTER                               = #DDFXCAPS_BLTARITHSTRETCHY

;*
;* Driver can do alpha blending for overlays.
;*
#DDFXCAPS_OVERLAYALPHA                            = $00000004

;*
;* Driver can do surface-reconstruction filtering for warped overlays.
;*
#DDFXCAPS_OVERLAYFILTER                           = #DDFXCAPS_OVERLAYARITHSTRETCHY



;****************************************************************************
;*
;* DIRECTDRAW STEREO VIEW CAPABILITIES
;*
;****************************************************************************

;*
;* This flag used to be DDSVCAPS_ENIGMA, which is now obsolete
;*
#DDSVCAPS_RESERVED1                               = $00000001

;*
;* This flag used to be DDSVCAPS_FLICKER, which is now obsolete
;*
#DDSVCAPS_RESERVED2                               = $00000002

;*
;* This flag used to be DDSVCAPS_REDBLUE, which is now obsolete
;*
#DDSVCAPS_RESERVED3                               = $00000004

;*
;* This flag used to be DDSVCAPS_SPLIT, which is now obsolete
;*
#DDSVCAPS_RESERVED4                               = $00000008

;*
;* The stereo view is accomplished with switching technology
;*
#DDSVCAPS_STEREOSEQUENTIAL                        = $00000010



;****************************************************************************
;*
;* DIRECTDRAWPALETTE CAPABILITIES
;*
;****************************************************************************

;*
;* Index is 4 bits.  There are sixteen color entries in the palette table.
;*
#DDPCAPS_4BIT                                     = $00000001

;*
;* Index is onto a 8 bit color index.  This field is only valid with the
;* DDPCAPS_1BIT, DDPCAPS_2BIT or DDPCAPS_4BIT capability and the target
;* surface is in 8bpp. Each color entry is one byte long and is an index
;* into destination surface's 8bpp palette.
;*
#DDPCAPS_8BITENTRIES                              = $00000002

;*
;* Index is 8 bits.  There are 256 color entries in the palette table.
;*
#DDPCAPS_8BIT                                     = $00000004

;*
;* Indicates that this DIRECTDRAWPALETTE should use the palette color array
;* passed into the lpDDColorArray parameter to initialize the DIRECTDRAWPALETTE
;* object.
;* This flag is obsolete. DirectDraw always initializes the color array from
;* the lpDDColorArray parameter. The definition remains for source-level
;* compatibility.
;*
#DDPCAPS_INITIALIZE                               = $00000000

;*
;* This palette is the one attached to the primary surface.  Changing this
;* table has immediate effect on the display unless DDPSETPAL_VSYNC is specified
;* and supported.
;*
#DDPCAPS_PRIMARYSURFACE                           = $00000010

;*
;* This palette is the one attached to the primary surface left.  Changing
;* this table has immediate effect on the display for the left eye unless
;* DDPSETPAL_VSYNC is specified and supported.
;*
#DDPCAPS_PRIMARYSURFACELEFT                       = $00000020

;*
;* This palette can have all 256 entries defined
;*
#DDPCAPS_ALLOW256                                 = $00000040

;*
;* This palette can have modifications to it synced with the monitors
;* refresh rate.
;*
#DDPCAPS_VSYNC                                    = $00000080

;*
;* Index is 1 bit.  There are two color entries in the palette table.
;*
#DDPCAPS_1BIT                                     = $00000100

;*
;* Index is 2 bit.  There are four color entries in the palette table.
;*
#DDPCAPS_2BIT                                     = $00000200

;*
;* The peFlags member of PALETTEENTRY denotes an 8 bit alpha value
;*
#DDPCAPS_ALPHA                                    = $00000400



;****************************************************************************
;*
;* DIRECTDRAWPALETTE SETENTRY CONSTANTS
;*
;****************************************************************************



;****************************************************************************
;*
;* DIRECTDRAWPALETTE GETENTRY CONSTANTS
;*
;****************************************************************************

;/* 0 is the only legal value */



;****************************************************************************
;*
;* DIRECTDRAWSURFACE SETPRIVATEDATA CONSTANTS
;*
;****************************************************************************
;*
;* The passed pointer is an IUnknown ptr. The cbData argument to SetPrivateData
;* must be set to sizeof(IUnknown*). DirectDraw will call AddRef through this
;* pointer and Release when the private data is destroyed. This includes when
;* the surface or palette is destroyed before such priovate data is destroyed.
;*
#DDSPD_IUNKNOWNPOINTER                            = $00000001

;*
;* Private data is only valid for the current state of the object,
;* as determined by the uniqueness value.
;*
#DDSPD_VOLATILE                                   = $00000002



;****************************************************************************
;*
;* DIRECTDRAWSURFACE SETPALETTE CONSTANTS
;*
;****************************************************************************



;****************************************************************************
;*
;* DIRECTDRAW BITDEPTH CONSTANTS
;*
;* NOTE:  These are only used to indicate supported bit depths.   These
;* are flags only, they are not to be used as an actual bit depth.   The
;* absolute numbers 1, 2, 4, 8, 16, 24 and 32 are used to indicate actual
;* bit depths in a surface or for changing the display mode.
;*
;****************************************************************************

;*
;* 1 bit per pixel.
;*
#DDBD_1                                           = $00004000

;*
;* 2 bits per pixel.
;*
#DDBD_2                                           = $00002000

;*
;* 4 bits per pixel.
;*
#DDBD_4                                           = $00001000

;*
;* 8 bits per pixel.
;*
#DDBD_8                                           = $00000800

;*
;* 16 bits per pixel.
;*
#DDBD_16                                          = $00000400

;*
;* 24 bits per pixel.
;*
#DDBD_24                                          = $00000200

;*
;* 32 bits per pixel.
;*
#DDBD_32                                          = $00000100



;****************************************************************************
;*
;* DIRECTDRAWSURFACE SET/GET COLOR KEY FLAGS
;*
;****************************************************************************

;*
;* Set if the structure contains a color space.  Not set if the structure
;* contains a single color key.
;*
#DDCKEY_COLORSPACE                                = $00000001

;/*
; * Set if the structure specifies a color key or color space which is to be
; * used as a destination color key for blt operations.
; */
#DDCKEY_DESTBLT                                   = $00000002

;*
;* Set if the structure specifies a color key or color space which is to be
;* used as a destination color key for overlay operations.
;*
#DDCKEY_DESTOVERLAY                               = $00000004

;*
;* Set if the structure specifies a color key or color space which is to be
;* used as a source color key for blt operations.
;*
#DDCKEY_SRCBLT                                    = $00000008

;*
;* Set if the structure specifies a color key or color space which is to be
;* used as a source color key for overlay operations.
;*
#DDCKEY_SRCOVERLAY                                = $00000010



;****************************************************************************
;*
;* DIRECTDRAW COLOR KEY CAPABILITY FLAGS
;*
;****************************************************************************

;*
;* Supports transparent blting using a color key to identify the replaceable
;* bits of the destination surface for RGB colors.
;*
#DDCKEYCAPS_DESTBLT                               = $00000001

;*
;* Supports transparent blting using a color space to identify the replaceable
;* bits of the destination surface for RGB colors.
;*
#DDCKEYCAPS_DESTBLTCLRSPACE                       = $00000002

;*
;* Supports transparent blting using a color space to identify the replaceable
;* bits of the destination surface for YUV colors.
;*
#DDCKEYCAPS_DESTBLTCLRSPACEYUV                    = $00000004

;*
;* Supports transparent blting using a color key to identify the replaceable
;* bits of the destination surface for YUV colors.
;*
#DDCKEYCAPS_DESTBLTYUV                            = $00000008

;*
;* Supports overlaying using colorkeying of the replaceable bits of the surface
;* being overlayed for RGB colors.
;*
#DDCKEYCAPS_DESTOVERLAY                           = $00000010

;*
;* Supports a color space as the color key for the destination for RGB colors.
;*
#DDCKEYCAPS_DESTOVERLAYCLRSPACE                   = $00000020

;*
;* Supports a color space as the color key for the destination for YUV colors.
;*
#DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV                = $00000040

;*
;* Supports only one active destination color key value for visible overlay
;* surfaces.
;*
#DDCKEYCAPS_DESTOVERLAYONEACTIVE                  = $00000080

;*
;* Supports overlaying using colorkeying of the replaceable bits of the
;* surface being overlayed for YUV colors.
;*
#DDCKEYCAPS_DESTOVERLAYYUV                        = $00000100

;*
;* Supports transparent blting using the color key for the source with
;* this surface for RGB colors.
;*
#DDCKEYCAPS_SRCBLT                                = $00000200

;*
;* Supports transparent blting using a color space for the source with
;* this surface for RGB colors.
;*
#DDCKEYCAPS_SRCBLTCLRSPACE                        = $00000400

;*
;* Supports transparent blting using a color space for the source with
;* this surface for YUV colors.
;*
#DDCKEYCAPS_SRCBLTCLRSPACEYUV                     = $00000800

;*
;* Supports transparent blting using the color key for the source with
;* this surface for YUV colors.
;*
#DDCKEYCAPS_SRCBLTYUV                             = $00001000

;*
;* Supports overlays using the color key for the source with this
;* overlay surface for RGB colors.
;*
#DDCKEYCAPS_SRCOVERLAY                            = $00002000

;*
;* Supports overlays using a color space as the source color key for
;* the overlay surface for RGB colors.
;*
#DDCKEYCAPS_SRCOVERLAYCLRSPACE                    = $00004000

;*
;* Supports overlays using a color space as the source color key for
;* the overlay surface for YUV colors.
;*
#DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV                 = $00008000

;*
;* Supports only one active source color key value for visible
;* overlay surfaces.
;*
#DDCKEYCAPS_SRCOVERLAYONEACTIVE                   = $00010000

;*
;* Supports overlays using the color key for the source with this
;* overlay surface for YUV colors.
;*
#DDCKEYCAPS_SRCOVERLAYYUV                         = $00020000

;*
;* there are no bandwidth trade-offs for using colorkey with an overlay
;*
#DDCKEYCAPS_NOCOSTOVERLAY                         = $00040000



;****************************************************************************
;*
;* DIRECTDRAW PIXELFORMAT FLAGS
;*
;****************************************************************************

;*
;* The surface has alpha channel information in the pixel format.
;*
#DDPF_ALPHAPIXELS                                 = $00000001

;*
;* The pixel format contains alpha only information
;*
#DDPF_ALPHA                                       = $00000002

;*
;* The FourCC code is valid.
;*
#DDPF_FOURCC                                      = $00000004

;*
;* The surface is 4-bit color indexed.
;*
#DDPF_PALETTEINDEXED4                             = $00000008

;*
;* The surface is indexed into a palette which stores indices
;* into the destination surface's 8-bit palette.
;*
#DDPF_PALETTEINDEXEDTO8                           = $00000010

;*
;* The surface is 8-bit color indexed.
;*
#DDPF_PALETTEINDEXED8                             = $00000020

;*
;* The RGB data in the pixel format structure is valid.
;*
#DDPF_RGB                                         = $00000040

;*
;* The surface will accept pixel data in the format specified
;* and compress it during the write.
;*
#DDPF_COMPRESSED                                  = $00000080

;*
;* The surface will accept RGB data and translate it during
;* the write to YUV data.  The format of the data to be written
;* will be contained in the pixel format structure.  The DDPF_RGB
;* flag will be set.
;*
#DDPF_RGBTOYUV                                    = $00000100

;*
;* pixel format is YUV - YUV data in pixel format struct is valid
;*
#DDPF_YUV                                         = $00000200

;*
;* pixel format is a z buffer only surface
;*
#DDPF_ZBUFFER                                     = $00000400

;*
;* The surface is 1-bit color indexed.
;*
#DDPF_PALETTEINDEXED1                             = $00000800

;*
;* The surface is 2-bit color indexed.
;*
#DDPF_PALETTEINDEXED2                             = $00001000

;*
;* The surface contains Z information in the pixels
;*
#DDPF_ZPIXELS                                     = $00002000

;*
;* The surface contains stencil information along with Z
;*
#DDPF_STENCILBUFFER                               = $00004000

;*
;* Premultiplied alpha format -- the color components have been
;* premultiplied by the alpha component.
;*
#DDPF_ALPHAPREMULT                                = $00008000

;*
;* Luminance data in the pixel format is valid.
;* Use this flag for luminance-only or luminance+alpha surfaces,
;* the bit depth is then ddpf.dwLuminanceBitCount.
;*
#DDPF_LUMINANCE                                   = $00020000

;*
;* Luminance data in the pixel format is valid.
;* Use this flag when hanging luminance off bumpmap surfaces,
;* the bit mask for the luminance portion of the pixel is then
;* ddpf.dwBumpLuminanceBitMask
;*
#DDPF_BUMPLUMINANCE                               = $00040000

;*
;* Bump map dUdV data in the pixel format is valid.
;*
#DDPF_BUMPDUDV                                    = $00080000





;*===========================================================================
;*
;*
;* DIRECTDRAW CALLBACK FLAGS
;*
;*
;*===========================================================================

;****************************************************************************
;*
;* DIRECTDRAW ENUMSURFACES FLAGS
;*
;****************************************************************************

;*
;* Enumerate all of the surfaces that meet the search criterion.
;*
#DDENUMSURFACES_ALL                               = $00000001

;*
;* A search hit is a surface that matches the surface description.
;*
#DDENUMSURFACES_MATCH                             = $00000002

;*
;* A search hit is a surface that does not match the surface description.
;*
#DDENUMSURFACES_NOMATCH                           = $00000004

;*
;* Enumerate the first surface that can be created which meets the search criterion.
;*
#DDENUMSURFACES_CANBECREATED                      = $00000008

;*
;* Enumerate the surfaces that already exist that meet the search criterion.
;*
#DDENUMSURFACES_DOESEXIST                         = $00000010



;****************************************************************************
;*
;* DIRECTDRAW SETDISPLAYMODE FLAGS
;*
;****************************************************************************

;*
;* The desired mode is a standard VGA mode
;*
#DDSDM_STANDARDVGAMODE                            = $00000001



;****************************************************************************
;*
;* DIRECTDRAW ENUMDISPLAYMODES FLAGS
;*
;****************************************************************************

;*
;* Enumerate Modes with different refresh rates.  EnumDisplayModes guarantees
;* that a particular mode will be enumerated only once.  This flag specifies whether
;* the refresh rate is taken into account when determining if a mode is unique.
;*
#DDEDM_REFRESHRATES                               = $00000001

;*
;* Enumerate VGA modes. Specify this flag if you wish to enumerate supported VGA
;* modes such as mode 0x13 in addition to the usual ModeX modes (which are always
;* enumerated if the application has previously called SetCooperativeLevel with the
;* DDSCL_ALLOWMODEX flag set).
;*
#DDEDM_STANDARDVGAMODES                           = $00000002



;****************************************************************************
;*
;* DIRECTDRAW SETCOOPERATIVELEVEL FLAGS
;*
;****************************************************************************

;*
;* Exclusive mode owner will be responsible for the entire primary surface.
;* GDI can be ignored. used with DD
;*
#DDSCL_FULLSCREEN                                 = $00000001

;*
;* allow CTRL_ALT_DEL to work while in fullscreen exclusive mode
;*
#DDSCL_ALLOWREBOOT                                = $00000002

;*
;* prevents DDRAW from modifying the application window.
;* prevents DDRAW from minimize/restore the application window on activation.
;*/
#DDSCL_NOWINDOWCHANGES                            = $00000004

;*
;* app wants to work as a regular Windows application
;*
#DDSCL_NORMAL                                     = $00000008

;*
;* app wants exclusive access
;*
#DDSCL_EXCLUSIVE                                  = $00000010

;*
;* app can deal with non-windows display modes
;*
#DDSCL_ALLOWMODEX                                 = $00000040

;*
;* this window will receive the focus messages
;*
#DDSCL_SETFOCUSWINDOW                             = $00000080

;*
;* this window is associated with the DDRAW object and will
;* cover the screen in fullscreen mode
;*
#DDSCL_SETDEVICEWINDOW                            = $00000100

;*
;* app wants DDRAW to create a window to be associated with the
;* DDRAW object
;*
#DDSCL_CREATEDEVICEWINDOW                         = $00000200

;*
;* App explicitly asks DDRAW/D3D to be multithread safe. This makes D3D
;* take the global crtisec more frequently.
;*
#DDSCL_MULTITHREADED                              = $00000400

;*
;* App specifies that it would like to keep the FPU set up for optimal Direct3D
;* performance (single precision and exceptions disabled) so Direct3D
;* does not need to explicitly set the FPU each time. This is assumed by
;* default in DirectX 7. See also DDSCL_FPUPRESERVE
;*
#DDSCL_FPUSETUP                                   = $00000800

;*
;* App specifies that it needs either double precision FPU or FPU exceptions
;* enabled. This makes Direct3D explicitly set the FPU state eah time it is
;* called. Setting the flag will reduce Direct3D performance. The flag is
;* assumed by default in DirectX 6 and earlier. See also DDSCL_FPUSETUP
;*
#DDSCL_FPUPRESERVE                                = $00001000



;****************************************************************************
;*
;* DIRECTDRAW BLT FLAGS
;*
;****************************************************************************

;*
;* Use the alpha information in the pixel format or the alpha channel surface
;* attached to the destination surface as the alpha channel for this blt.
;*
#DDBLT_ALPHADEST                                  = $00000001

;*
;* Use the dwConstAlphaDest field in the DDBLTFX structure as the alpha channel
;* for the destination surface for this blt.
;*
#DDBLT_ALPHADESTCONSTOVERRIDE                     = $00000002

;*
;* The NEG suffix indicates that the destination surface becomes more
;* transparent as the alpha value increases. (0 is opaque)
;*
#DDBLT_ALPHADESTNEG                               = $00000004

;*
;* Use the lpDDSAlphaDest field in the DDBLTFX structure as the alpha
;* channel for the destination for this blt.
;*
#DDBLT_ALPHADESTSURFACEOVERRIDE                   = $00000008

;*
;* Use the dwAlphaEdgeBlend field in the DDBLTFX structure as the alpha channel
;* for the edges of the image that border the color key colors.
;*
#DDBLT_ALPHAEDGEBLEND                             = $00000010

;*
;* Use the alpha information in the pixel format or the alpha channel surface
;* attached to the source surface as the alpha channel for this blt.
;*
#DDBLT_ALPHASRC                                   = $00000020

;*
;* Use the dwConstAlphaSrc field in the DDBLTFX structure as the alpha channel
;* for the source for this blt.
;*
#DDBLT_ALPHASRCCONSTOVERRIDE                      = $00000040

;*
;* The NEG suffix indicates that the source surface becomes more transparent
;* as the alpha value increases. (0 is opaque)
;*
#DDBLT_ALPHASRCNEG                                = $00000080

;*
;* Use the lpDDSAlphaSrc field in the DDBLTFX structure as the alpha channel
;* for the source for this blt.
;*
#DDBLT_ALPHASRCSURFACEOVERRIDE                    = $00000100

;*
;* Do this blt asynchronously through the FIFO in the order received.  If
;* there is no room in the hardware FIFO fail the call.
;*
#DDBLT_ASYNC                                      = $00000200

;*
;* Uses the dwFillColor field in the DDBLTFX structure as the RGB color
;* to fill the destination rectangle on the destination surface with.
;*
#DDBLT_COLORFILL                                  = $00000400

;*
;* Uses the dwDDFX field in the DDBLTFX structure to specify the effects
;* to use for the blt.
;*
#DDBLT_DDFX                                       = $00000800

;*
;* Uses the dwDDROPS field in the DDBLTFX structure to specify the ROPS
;* that are not part of the Win32 API.
;*
#DDBLT_DDROPS                                     = $00001000

;*
;* Use the color key associated with the destination surface.
;*
#DDBLT_KEYDEST                                    = $00002000

;*
;* Use the dckDestColorkey field in the DDBLTFX structure as the color key
;* for the destination surface.
;*
#DDBLT_KEYDESTOVERRIDE                            = $00004000

;*
;* Use the color key associated with the source surface.
;*
#DDBLT_KEYSRC                                     = $00008000

;*
;* Use the dckSrcColorkey field in the DDBLTFX structure as the color key
;* for the source surface.
;*
#DDBLT_KEYSRCOVERRIDE                             = $00010000

;*
;* Use the dwROP field in the DDBLTFX structure for the raster operation
;* for this blt.  These ROPs are the same as the ones defined in the Win32 API.
;*
#DDBLT_ROP                                        = $00020000

;*
;* Use the dwRotationAngle field in the DDBLTFX structure as the angle
;* (specified in 1/100th of a degree) to rotate the surface.
;*
#DDBLT_ROTATIONANGLE                              = $00040000

;*
;* Z-buffered blt using the z-buffers attached to the source and destination
;* surfaces and the dwZBufferOpCode field in the DDBLTFX structure as the
;* z-buffer opcode.
;*
#DDBLT_ZBUFFER                                    = $00080000

;*
;* Z-buffered blt using the dwConstDest Zfield and the dwZBufferOpCode field
;* in the DDBLTFX structure as the z-buffer and z-buffer opcode respectively
;* for the destination.
;*
#DDBLT_ZBUFFERDESTCONSTOVERRIDE                   = $00100000

;*
;* Z-buffered blt using the lpDDSDestZBuffer field and the dwZBufferOpCode
;* field in the DDBLTFX structure as the z-buffer and z-buffer opcode
;* respectively for the destination.
;*
#DDBLT_ZBUFFERDESTOVERRIDE                        = $00200000

;*
;* Z-buffered blt using the dwConstSrcZ field and the dwZBufferOpCode field
;* in the DDBLTFX structure as the z-buffer and z-buffer opcode respectively
;* for the source.
;*
#DDBLT_ZBUFFERSRCCONSTOVERRIDE                    = $00400000

;*
;* Z-buffered blt using the lpDDSSrcZBuffer field and the dwZBufferOpCode
;* field in the DDBLTFX structure as the z-buffer and z-buffer opcode
;* respectively for the source.
;*
#DDBLT_ZBUFFERSRCOVERRIDE                         = $00800000

;*
;* wait until the device is ready to handle the blt
;* this will cause blt to not return DDERR_WASSTILLDRAWING
;*
#DDBLT_WAIT                                       = $01000000

;*
;* Uses the dwFillDepth field in the DDBLTFX structure as the depth value
;* to fill the destination rectangle on the destination Z-buffer surface
;* with.
;*
#DDBLT_DEPTHFILL                                  = $02000000


;*
;* wait until the device is ready to handle the blt
;* this will cause blt to not return DDERR_WASSTILLDRAWING
;*
#DDBLT_DONOTWAIT                                  = $08000000



;****************************************************************************
;*
;* BLTFAST FLAGS
;*
;****************************************************************************

#DDBLTFAST_NOCOLORKEY                             = $00000000
#DDBLTFAST_SRCCOLORKEY                            = $00000001
#DDBLTFAST_DESTCOLORKEY                           = $00000002
#DDBLTFAST_WAIT                                   = $00000010
#DDBLTFAST_DONOTWAIT                              = $00000020



;****************************************************************************
;*
;* FLIP FLAGS
;*
;****************************************************************************

#DDFLIP_WAIT                                      = $00000001

;*
;* Indicates that the target surface contains the even field of video data.
;* This flag is only valid with an overlay surface.
;*
#DDFLIP_EVEN                                      = $00000002

;*
;* Indicates that the target surface contains the odd field of video data.
;* This flag is only valid with an overlay surface.
;*
#DDFLIP_ODD                                       = $00000004

;*
;* Causes DirectDraw to perform the physical flip immediately and return
;* to the application. Typically, what was the front buffer but is now the back
;* buffer will still be visible (depending on timing) until the next vertical
;* retrace. Subsequent operations involving the two flipped surfaces will
;* not check to see if the physical flip has finished (i.e. will not return
;* DDERR_WASSTILLDRAWING for that reason (but may for other reasons)).
;* This allows an application to perform Flips at a higher frequency than the
;* monitor refresh rate, but may introduce visible artifacts.
;* Only effective if DDCAPS2_FLIPNOVSYNC is set. If that bit is not set,
;* DDFLIP_NOVSYNC has no effect.
;*
#DDFLIP_NOVSYNC                                   = $00000008

;*
;* Flip Interval Flags. These flags indicate how many vertical retraces to wait between
;* each flip. The default is one. DirectDraw will return DDERR_WASSTILLDRAWING for each
;* surface involved in the flip until the specified number of vertical retraces has
;* ocurred. Only effective if DDCAPS2_FLIPINTERVAL is set. If that bit is not set,
;* DDFLIP_INTERVALn has no effect.
;*

;*
;* DirectDraw will flip on every other vertical sync
;*
#DDFLIP_INTERVAL2                                 = $02000000

;*
;* DirectDraw will flip on every third vertical sync
;*
#DDFLIP_INTERVAL3                                 = $03000000

;*
;* DirectDraw will flip on every fourth vertical sync
;*
#DDFLIP_INTERVAL4                                 = $04000000

;*
;* DirectDraw will flip and display a main stereo surface
;*
#DDFLIP_STEREO                                    = $00000010

;*
;* On IDirectDrawSurface7 and higher interfaces, the default is DDFLIP_WAIT. If you wish
;* to override the default and use time when the accelerator is busy (as denoted by
;* the DDERR_WASSTILLDRAWING return code) then use DDFLIP_DONOTWAIT.
;*
#DDFLIP_DONOTWAIT                                 = $00000020



;****************************************************************************
;*
;* DIRECTDRAW SURFACE OVERLAY FLAGS
;*
;****************************************************************************

;*
;* Use the alpha information in the pixel format or the alpha channel surface
;* attached to the destination surface as the alpha channel for the
;* destination overlay.
;*
#DDOVER_ALPHADEST                                 = $00000001

;*
;* Use the dwConstAlphaDest field in the DDOVERLAYFX structure as the
;* destination alpha channel for this overlay.
;*
#DDOVER_ALPHADESTCONSTOVERRIDE                    = $00000002

;*
;* The NEG suffix indicates that the destination surface becomes more
;* transparent as the alpha value increases.
;*
#DDOVER_ALPHADESTNEG                              = $00000004

;*
;* Use the lpDDSAlphaDest field in the DDOVERLAYFX structure as the alpha
;* channel destination for this overlay.
;*
#DDOVER_ALPHADESTSURFACEOVERRIDE                  = $00000008

;*
;* Use the dwAlphaEdgeBlend field in the DDOVERLAYFX structure as the alpha
;* channel for the edges of the image that border the color key colors.
;*
#DDOVER_ALPHAEDGEBLEND                            = $00000010

;*
;* Use the alpha information in the pixel format or the alpha channel surface
;* attached to the source surface as the source alpha channel for this overlay.
;*
#DDOVER_ALPHASRC                                  = $00000020

;*
;* Use the dwConstAlphaSrc field in the DDOVERLAYFX structure as the source
;* alpha channel for this overlay.
;*
#DDOVER_ALPHASRCCONSTOVERRIDE                     = $00000040

;*
;* The NEG suffix indicates that the source surface becomes more transparent
;* as the alpha value increases.
;*
#DDOVER_ALPHASRCNEG                               = $00000080

;*
;* Use the lpDDSAlphaSrc field in the DDOVERLAYFX structure as the alpha channel
;* source for this overlay.
;*
#DDOVER_ALPHASRCSURFACEOVERRIDE                   = $00000100

;*
;* Turn this overlay off.
;*
#DDOVER_HIDE                                      = $00000200

;*
;* Use the color key associated with the destination surface.
;*
#DDOVER_KEYDEST                                   = $00000400

;*
;* Use the dckDestColorkey field in the DDOVERLAYFX structure as the color key
;* for the destination surface
;*
#DDOVER_KEYDESTOVERRIDE                           = $00000800

;*
;* Use the color key associated with the source surface.
;*
#DDOVER_KEYSRC                                    = $00001000

;*
;* Use the dckSrcColorkey field in the DDOVERLAYFX structure as the color key
;* for the source surface.
;*
#DDOVER_KEYSRCOVERRIDE                            = $00002000

;*
;* Turn this overlay on.
;*
#DDOVER_SHOW                                      = $00004000

;*
;* Add a dirty rect to an emulated overlayed surface.
;*
#DDOVER_ADDDIRTYRECT                              = $00008000

;*
;* Redraw all dirty rects on an emulated overlayed surface.
;*
#DDOVER_REFRESHDIRTYRECTS                         = $00010000

;*
;* Redraw the entire surface on an emulated overlayed surface.
;*
#DDOVER_REFRESHALL                                = $00020000

;*
;* Use the overlay FX flags to define special overlay FX
;*
#DDOVER_DDFX                                      = $00080000

;*
;* Autoflip the overlay when ever the video port autoflips
;*
#DDOVER_AUTOFLIP                                  = $00100000

;*
;* Display each field of video port data individually without
;* causing any jittery artifacts
;*
#DDOVER_BOB                                       = $00200000

;*
;* Indicates that bob/weave decisions should not be overridden by other
;* interfaces.
;*
#DDOVER_OVERRIDEBOBWEAVE                          = $00400000

;*
;* Indicates that the surface memory is composed of interleaved fields.
;*
#DDOVER_INTERLEAVED                               = $00800000

;*
;* Indicates that bob will be performed using hardware rather than
;* software or emulated.
;*
#DDOVER_BOBHARDWARE                               = $01000000

;*
;* Indicates that overlay FX structure contains valid ARGB scaling factors.
;*
#DDOVER_ARGBSCALEFACTORS                          = $02000000

;*
;* Indicates that ARGB scaling factors can be degraded to fit driver capabilities.
;*
#DDOVER_DEGRADEARGBSCALING                        = $04000000



;****************************************************************************
;*
;* DIRECTDRAWSURFACE LOCK FLAGS
;*
;****************************************************************************

;*
;* The default.  Set to indicate that Lock should return a valid memory pointer
;* to the top of the specified rectangle.  If no rectangle is specified then a
;* pointer to the top of the surface is returned.
;*
#DDLOCK_SURFACEMEMORYPTR                          = $00000000      ;// default

;*
;* Set to indicate that Lock should wait until it can obtain a valid memory
;* pointer before returning.  If this bit is set, Lock will never return
;* DDERR_WASSTILLDRAWING.
;*
#DDLOCK_WAIT                                      = $00000001

;*
;* Set if an event handle is being passed to Lock.  Lock will trigger the event
;* when it can return the surface memory pointer requested.
;*
#DDLOCK_EVENT                                     = $00000002

;*
;* Indicates that the surface being locked will only be read from.
;*
#DDLOCK_READONLY                                  = $00000010

;*
;* Indicates that the surface being locked will only be written to
;*
#DDLOCK_WRITEONLY                                 = $00000020

;*
;* Indicates that a system wide lock should not be taken when this surface
;* is locked. This has several advantages (cursor responsiveness, ability
;* to call more Windows functions, easier debugging) when locking video
;* memory surfaces. However, an application specifying this flag must
;* comply with a number of conditions documented in the help file.
;* Furthermore, this flag cannot be specified when locking the primary.
;*
#DDLOCK_NOSYSLOCK                                 = $00000800

;*
;* Used only with Direct3D Vertex Buffer Locks. Indicates that no vertices
;* that were referred to in Draw*PrimtiveVB calls since the start of the
;* frame (or the last lock without this flag) will be modified during the
;* lock. This can be useful when one is only appending data to the vertex
;* buffer
;*
#DDLOCK_NOOVERWRITE                               = $00001000

;*
;* Indicates that no assumptions will be made about the contents of the 
;* surface or vertex buffer during this lock.
;* This enables two things:
;* -    Direct3D or the driver may provide an alternative memory
;*      area as the vertex buffer. This is useful when one plans to clear the
;*      contents of the vertex buffer and fill in new data.
;* -    Drivers sometimes store surface data in a re-ordered format.
;*      When the application locks the surface, the driver is forced to un-re-order
;*      the surface data before allowing the application to see the surface contents.
;*      This flag is a hint to the driver that it can skip the un-re-ordering process
;*      since the application plans to overwrite every single pixel in the surface
;*      or locked rectangle (and so erase any un-re-ordered pixels anyway).
;*      Applications should always set this flag when they intend to overwrite the entire
;*      surface or locked rectangle.
;*
#DDLOCK_DISCARDCONTENTS                           = $00002000

;*
;* DDLOCK_OKTOSWAP is an older, less informative name for DDLOCK_DISCARDCONTENTS
;*
#DDLOCK_OKTOSWAP                                  = $00002000

;*
;* On IDirectDrawSurface7 and higher interfaces, the default is DDLOCK_WAIT. If you wish
;* to override the default and use time when the accelerator is busy (as denoted by
;* the DDERR_WASSTILLDRAWING return code) then use DDLOCK_DONOTWAIT.
;*
#DDLOCK_DONOTWAIT                                 = $00004000



;****************************************************************************
;*
;* DIRECTDRAWSURFACE PAGELOCK FLAGS
;*
;****************************************************************************

;*
;* No flags defined at present
;*



;****************************************************************************
;*
;* DIRECTDRAWSURFACE PAGEUNLOCK FLAGS
;*
;****************************************************************************

;*
;* No flags defined at present
;*



;****************************************************************************
;*
;* DIRECTDRAWSURFACE BLT FX FLAGS
;*
;***************************************************************************

;*
;* If stretching, use arithmetic stretching along the Y axis for this blt.
;*
#DDBLTFX_ARITHSTRETCHY                            = $00000001

;*
;* Do this blt mirroring the surface left to right.  Spin the
;* surface around its y-axis.
;*
#DDBLTFX_MIRRORLEFTRIGHT                          = $00000002

;*
;* Do this blt mirroring the surface up and down.  Spin the surface
;* around its x-axis.
;*
#DDBLTFX_MIRRORUPDOWN                             = $00000004

;*
;* Schedule this blt to avoid tearing.
;*
#DDBLTFX_NOTEARING                                = $00000008

;*
;* Do this blt rotating the surface one hundred and eighty degrees.
;*
#DDBLTFX_ROTATE180                                = $00000010

;*
;* Do this blt rotating the surface two hundred and seventy degrees.
;*
#DDBLTFX_ROTATE270                                = $00000020

;*
;* Do this blt rotating the surface ninety degrees.
;*
#DDBLTFX_ROTATE90                                 =$00000040

;*
;* Do this z blt using dwZBufferLow and dwZBufferHigh as  range values
;* specified to limit the bits copied from the source surface.
;*
#DDBLTFX_ZBUFFERRANGE                             = $00000080

;*
;* Do this z blt adding the dwZBufferBaseDest to each of the sources z values
;* before comparing it with the desting z values.
;*
#DDBLTFX_ZBUFFERBASEDEST                          = $00000100



;****************************************************************************
;*
;* DIRECTDRAWSURFACE OVERLAY FX FLAGS
;*
;****************************************************************************

;*
;* If stretching, use arithmetic stretching along the Y axis for this overlay.
;*
#DDOVERFX_ARITHSTRETCHY                           = $00000001

;*
;* Mirror the overlay across the vertical axis
;*
#DDOVERFX_MIRRORLEFTRIGHT                         = $00000002

;*
;* Mirror the overlay across the horizontal axis
;*
#DDOVERFX_MIRRORUPDOWN                            = $00000004



;****************************************************************************
;*
;* DIRECTDRAW WAITFORVERTICALBLANK FLAGS
;*
;****************************************************************************

;*
;* return when the vertical blank interval begins
;*
#DDWAITVB_BLOCKBEGIN                              = $00000001

;*
;* set up an event to trigger when the vertical blank begins
;*
#DDWAITVB_BLOCKBEGINEVENT                         = $00000002

;*
;* return when the vertical blank interval ends and display begins
;*
#DDWAITVB_BLOCKEND                                = $00000004



;****************************************************************************
;*
;* DIRECTDRAW GETFLIPSTATUS FLAGS
;*
;****************************************************************************

;*
;* is it OK to flip now?
;*
#DDGFS_CANFLIP                                    = $00000001

;*
;* is the last flip finished?
;*
#DDGFS_ISFLIPDONE                                 = $00000002



;****************************************************************************
;*
;* DIRECTDRAW GETBLTSTATUS FLAGS
;*
;****************************************************************************

;*
;* is it OK to blt now?
;*
#DDGBS_CANBLT                                     = $00000001

;*
;* is the blt to the surface finished?
;*
#DDGBS_ISBLTDONE                                  = $00000002



;****************************************************************************
;*
;* DIRECTDRAW ENUMOVERLAYZORDER FLAGS
;*
;****************************************************************************

;*
;* Enumerate overlays back to front.
;*
#DDENUMOVERLAYZ_BACKTOFRONT                       = $00000000

;*
;* Enumerate overlays front to back
;*
#DDENUMOVERLAYZ_FRONTTOBACK                       = $00000001



;****************************************************************************
;*
;* DIRECTDRAW UPDATEOVERLAYZORDER FLAGS
;*
;****************************************************************************

;*
;* Send overlay to front
;*
#DDOVERZ_SENDTOFRONT                              = $00000000

;*
;* Send overlay to back
;*
#DDOVERZ_SENDTOBACK                               = $00000001

;*
;* Move Overlay forward
;*
#DDOVERZ_MOVEFORWARD                              = $00000002

;*
;* Move Overlay backward
;*
#DDOVERZ_MOVEBACKWARD                             = $00000003

;*
;* Move Overlay in front of relative surface
;*
#DDOVERZ_INSERTINFRONTOF                          = $00000004

;*
;* Move Overlay in back of relative surface
;
#DDOVERZ_INSERTINBACKOF                           = $00000005



;****************************************************************************
;*
;* DIRECTDRAW SETGAMMARAMP FLAGS
;*
;****************************************************************************

;*
;* Request calibrator to adjust the gamma ramp according to the physical
;* properties of the display so that the result should appear identical
;* on all systems.
;*
#DDSGR_CALIBRATE                                  = $00000001



;****************************************************************************
;*
;* DIRECTDRAW STARTMODETEST FLAGS
;*
;****************************************************************************

;*
;* Indicates that the mode being tested has passed
;*
#DDSMT_ISTESTREQUIRED                             = $00000001



;****************************************************************************
;*
;* DIRECTDRAW EVALUATEMODE FLAGS
;*
;****************************************************************************

;*
;* Indicates that the mode being tested has passed
;*
#DDEM_MODEPASSED                                  = $00000001

;*
;* Indicates that the mode being tested has failed
;*
#DDEM_MODEFAILED                                  = $00000002



;*
;* DDBLTFX
;* Used to pass override information to the DIRECTDRAWSURFACE callback Blt.
;*
Structure DDBLTFX
   dwSize.l;                         // size of structure
   dwDDFX.l;                         // FX operations
   dwROP.l;                          // Win32 raster operations
   dwDDROP.l;                        // Raster operations new for DirectDraw
   dwRotationAngle.l;                // Rotation angle for blt
   dwZBufferOpCode.l;                // ZBuffer compares
   dwZBufferLow.l;                   // Low limit of Z buffer
   dwZBufferHigh.l;                  // High limit of Z buffer
   dwZBufferBaseDest.l;              // Destination base value
   dwZDestConstBitDepth.l;           // Bit depth used to specify Z constant for destination

    StructureUnion
       dwZDestConst.l;               // Constant to use as Z buffer for dest
       lpDDSZBufferDest.l;           // Surface to use as Z buffer for dest
    EndStructureUnion

   dwZSrcConstBitDepth.l;            // Bit depth used to specify Z constant for source

    StructureUnion
       dwZSrcConst.l;                // Constant to use as Z buffer for src
       lpDDSZBufferSrc.l;            // Surface to use as Z buffer for src
    EndStructureUnion

   dwAlphaEdgeBlendBitDepth.l;       // Bit depth used to specify constant for alpha edge blend
   dwAlphaEdgeBlend.l;               // Alpha for edge blending
   dwReserved.l;
   dwAlphaDestConstBitDepth.l;       // Bit depth used to specify alpha constant for destination

    StructureUnion
       dwAlphaDestConst.l;           // Constant to use as Alpha Channel
       lpDDSAlphaDest.l;             // Surface to use as Alpha Channel
    EndStructureUnion

   dwAlphaSrcConstBitDepth.l;        // Bit depth used to specify alpha constant for source

    StructureUnion
       dwAlphaSrcConst.l;            // Constant to use as Alpha Channel
       lpDDSAlphaSrc.l;              // Surface to use as Alpha Channel
    EndStructureUnion

    StructureUnion
       dwFillColor.l;                // color in RGB or Palettized
       dwFillDepth.l;                // depth value for z-buffer
       dwFillPixel.l;                // pixel value for RGBA or RGBZ
       lpDDSPattern.l;               // Surface to use as pattern
    EndStructureUnion

   ddckDestColorkey.DDCOLORKEY;      // DestColorkey override
   ddckSrcColorkey.DDCOLORKEY;       // SrcColorkey override
EndStructure



;*
;* DDOVERLAYFX
;*
Structure DDOVERLAYFX
   dwSize.l;                         // size of structure
   dwAlphaEdgeBlendBitDepth.l;       // Bit depth used to specify constant for alpha edge blend
   dwAlphaEdgeBlend.l;               // Constant to use as alpha for edge blend
   dwReserved.l;
   dwAlphaDestConstBitDepth.l;       // Bit depth used to specify alpha constant for destination

    StructureUnion
       dwAlphaDestConst.l;           // Constant to use as alpha channel for dest
       lpDDSAlphaDest.l;             // Surface to use as alpha channel for dest
    EndStructureUnion

   dwAlphaSrcConstBitDepth.l;        // Bit depth used to specify alpha constant for source

    StructureUnion
       dwAlphaSrcConst.l;            // Constant to use as alpha channel for src
       lpDDSAlphaSrc.l;              // Surface to use as alpha channel for src
    EndStructureUnion

   dckDestColorkey.DDCOLORKEY;       // DestColorkey override
   dckSrcColorkey.DDCOLORKEY;        // DestColorkey override
   dwDDFX.l;                         // Overlay FX
   dwFlags.l;                        // flags
EndStructure



;*
;* DDBLTBATCH: BltBatch entry structure
;*
Structure DDBLTBATCH
    lprDest.l;
    lpDDSSrc.l;
    lprSrc.l;
    dwFlags.l;
    lpDDBltFx.l;
EndStructure





;*
;* Flags for DirectDrawEnumerateEx
;* DirectDrawEnumerateEx supercedes DirectDrawEnumerate. You must use GetProcAddress to
;* obtain a function pointer (of type LPDIRECTDRAWENUMERATEEX) to DirectDrawEnumerateEx.
;* By default, only the primary display device is enumerated.
;* DirectDrawEnumerate is equivalent to DirectDrawEnumerate(,,DDENUM_NONDISPLAYDEVICES)
;*

;*
;* This flag causes enumeration of any GDI display devices which are part of
;* the Windows Desktop
;*
#DDENUM_ATTACHEDSECONDARYDEVICES                  = $00000001

;*
;* This flag causes enumeration of any GDI display devices which are not
;* part of the Windows Desktop
;*
#DDENUM_DETACHEDSECONDARYDEVICES                  = $00000002

;*
;* This flag causes enumeration of non-display devices
;*
#DDENUM_NONDISPLAYDEVICES                         = $00000004


#REGSTR_KEY_DDHW_DESCRIPTION.s                    = "Description"
#REGSTR_KEY_DDHW_DRIVERNAME.s                     = "DriverName"
#REGSTR_PATH_DDHW.s                               = "Hardware\\DirectDrawDrivers"

#DDCREATE_HARDWAREONLY                            = $00000001
#DDCREATE_EMULATIONONLY                           = $00000002





;*
;*  This is the structure within which DirectDraw returns data about the current graphics driver and chipset
;*

#MAX_DDDEVICEID_STRING                            = 512

Structure tagDDDEVICEIDENTIFIER
   ;*
   ;* These elements are for presentation to the user only. They should not be used to identify particular
   ;* drivers, since this is unreliable and many different strings may be associated with the same
   ;* device, and the same driver from different vendors.
   ;*
 ;char    szDriver[MAX_DDDEVICEID_STRING];
 ;char    szDescription[MAX_DDDEVICEID_STRING];
   szDriver.b[#MAX_DDDEVICEID_STRING]
   szDescription.b[#MAX_DDDEVICEID_STRING]

   ;*
   ;* This element is the version of the DirectDraw/3D driver. It is legal to do <, > comparisons
   ;* on the whole 64 bits. Caution should be exercised if you use this element to identify problematic
   ;* drivers. It is recommended that guidDeviceIdentifier is used for this purpose.
   ;*
   ;* This version has the form:
   ;*  wProduct = HIWORD(liDriverVersion.HighPart)
   ;*  wVersion = LOWORD(liDriverVersion.HighPart)
   ;*  wSubVersion = HIWORD(liDriverVersion.LowPart)
   ;*  wBuild = LOWORD(liDriverVersion.LowPart)
   ;*
   dwDriverVersionLowPart.l;     /* Defined for 16 bit driver components */
   dwDriverVersionHighPart.l;

   ;*
   ;* These elements can be used to identify particular chipsets. Use with extreme caution.
   ;*   dwVendorId     Identifies the manufacturer. May be zero if unknown.
   ;*   dwDeviceId     Identifies the type of chipset. May be zero if unknown.
   ;*   dwSubSysId     Identifies the subsystem, typically this means the particular board. May be zero if unknown.
   ;*   dwRevision     Identifies the revision level of the chipset. May be zero if unknown.
   ;*
   dwVendorId.l;
   dwDeviceId.l;
   dwSubSysId.l;
   dwRevision.l;

   ;*
   ;* This element can be used to check changes in driver/chipset. This GUID is a unique identifier for the
   ;* driver/chipset pair. Use this element if you wish to track changes to the driver/chipset in order to
   ;* reprofile the graphics subsystem.
   ;* This element can also be used to identify particular problematic drivers.
   ;*
   guidDeviceIdentifier.GUID;
EndStructure



Structure tagDDDEVICEIDENTIFIER2
   ;*
   ;* These elements are for presentation to the user only. They should not be used to identify particular
   ;* drivers, since this is unreliable and many different strings may be associated with the same
   ;* device, and the same driver from different vendors.
   ;*
 ;char    szDriver[MAX_DDDEVICEID_STRING];
 ;char    szDescription[MAX_DDDEVICEID_STRING];
   szDriver.b[#MAX_DDDEVICEID_STRING]
   szDescription.b[#MAX_DDDEVICEID_STRING]

   ;*
   ;* This element is the version of the DirectDraw/3D driver. It is legal to do <, > comparisons
   ;* on the whole 64 bits. Caution should be exercised if you use this element to identify problematic
   ;* drivers. It is recommended that guidDeviceIdentifier is used for this purpose.
   ;*
   ;* This version has the form:
   ;*  wProduct = HIWORD(liDriverVersion.HighPart)
   ;*  wVersion = LOWORD(liDriverVersion.HighPart)
   ;*  wSubVersion = HIWORD(liDriverVersion.LowPart)
   ;*  wBuild = LOWORD(liDriverVersion.LowPart)
   ;*
   dwDriverVersionLowPart.l;     /* Defined for 16 bit driver components */
   dwDriverVersionHighPart.l;

   ;*
   ;* These elements can be used to identify particular chipsets. Use with extreme caution.
   ;*   dwVendorId     Identifies the manufacturer. May be zero if unknown.
   ;*   dwDeviceId     Identifies the type of chipset. May be zero if unknown.
   ;*   dwSubSysId     Identifies the subsystem, typically this means the particular board. May be zero if unknown.
   ;*   dwRevision     Identifies the revision level of the chipset. May be zero if unknown.
   ;*
   dwVendorId.l;
   dwDeviceId.l;
   dwSubSysId.l;
   dwRevision.l;

   ;*
   ;* This element can be used to check changes in driver/chipset. This GUID is a unique identifier for the
   ;* driver/chipset pair. Use this element if you wish to track changes to the driver/chipset in order to
   ;* reprofile the graphics subsystem.
   ;* This element can also be used to identify particular problematic drivers.
   ;*
   guidDeviceIdentifier.GUID;

   ;*
   ;* This element is used to determine the Windows Hardware Quality Lab (WHQL)
   ;* certification level for this driver/device pair.
   ;*
   dwWHQLLevel.l;
EndStructure

;*
;* Flags for the IDirectDraw4::GetDeviceIdentifier method
;*

;*
;* This flag causes GetDeviceIdentifier to return information about the host (typically 2D) adapter in a system equipped
;* with a stacked secondary 3D adapter. Such an adapter appears to the application as if it were part of the
;* host adapter, but is typically physcially located on a separate card. The stacked secondary's information is
;* returned when GetDeviceIdentifier's dwFlags field is zero, since this most accurately reflects the qualities
;* of the DirectDraw object involved.
;*
#DDGDI_GETHOSTIDENTIFIER                          = $00000001





;*===========================================================================
;*
;*
;* DIRECTDRAW RETURN CODES
;*
;* The return values from DirectDraw Commands and Surface that return an HRESULT
;* are codes from DirectDraw concerning the results of the action
;* requested by DirectDraw.
;*
;*===========================================================================

;*
;* Status is OK
;*
;* Issued by: DirectDraw Commands and all callbacks
;*
#DD_OK                         = 0
#DD_FALSE                      = 1



;****************************************************************************
;*
;* DIRECTDRAW ENUMCALLBACK RETURN VALUES
;*
;* EnumCallback returns are used to control the flow of the DIRECTDRAW and
;* DIRECTDRAWSURFACE object enumerations.   They can only be returned by
;* enumeration callback routines.
;*
;****************************************************************************

;*
;* stop the enumeration
;*
#DDENUMRET_CANCEL              = 0

;*
;* continue the enumeration
;*
#DDENUMRET_OK                  = 1





;*
;* INTERACES FOLLOW:
;*
;*      IDirectDraw7
;*
#DD_QueryInterface             = 0
#DD_AddRef                     = 4
#DD_Release                    = 8
#DD_Compact                    = 12
#DD_CreateClipper              = 16
#DD_CreatePalette              = 20
#DD_CreateSurface              = 24
#DD_DuplicateSurface           = 28
#DD_EnumDisplayModes           = 32
#DD_EnumSurfaces               = 36
#DD_FlipToGDISurface           = 40
#DD_GetCaps                    = 44
#DD_GetDisplayMode             = 48
#DD_GetFourCCCodes             = 52
#DD_GetGDISurface              = 56
#DD_GetMonitorFrequency        = 60
#DD_GetScanLine                = 64
#DD_GetVerticalBlankStatus     = 68
#DD_Initialize                 = 72
#DD_RestoreDisplayMode         = 76
#DD_SetCooperativeLevel        = 80
#DD_SetDisplayMode             = 84
#DD_WaitForVerticalBlank       = 88
;    /*** Added in the v2 interface ***/
#DD_GetAvailableVidMem         = 92
;    /*** Added in the V4 Interface ***/
#DD_GetSurfaceFromDC           = 96
#DD_RestoreAllSurfaces         = 100
#DD_TestCooperativeLevel       = 104
#DD_GetDeviceIdentifier        = 108
;    /*** Added in the V7 Interface ***/
#DD_StartModeTest              = 112
#DD_EvaluateMode               = 116



;*
;* IDirectDrawSurface7
;*
#DDS_QueryInterface               = 0  
#DDS_AddRef                       = 4  
#DDS_Release                      = 8  
#DDS_AddAttachedSurface           = 12 
#DDS_AddOverlayDirtyRect          = 16 
#DDS_Blt                          = 20 
#DDS_BltBatch                     = 24 
#DDS_BltFast                      = 28 
#DDS_DeleteAttachedSurface        = 32 
#DDS_EnumAttachedSurfaces         = 36 
#DDS_EnumOverlayZOrders           = 40 
#DDS_Flip                         = 44 
#DDS_GetAttachedSurface           = 48 
#DDS_GetBltStatus                 = 52 
#DDS_GetCaps                      = 56 
#DDS_GetClipper                   = 60 
#DDS_GetColorKey                  = 64 
#DDS_GetDC                        = 68 
#DDS_GetFlipStatus                = 72 
#DDS_GetOverlayPosition           = 76 
#DDS_GetPalette                   = 80 
#DDS_GetPixelFormat               = 84 
#DDS_GetSurfaceDesc               = 88 
#DDS_Initialize                   = 92 
#DDS_IsLost                       = 96 
#DDS_Lock                         = 100
#DDS_ReleaseDC                    = 104
#DDS_Restore                      = 108
#DDS_SetClipper                   = 112
#DDS_SetColorKey                  = 116
#DDS_SetOverlayPosition           = 120
#DDS_SetPalette                   = 124
#DDS_Unlock                       = 128
#DDS_UpdateOverlay                = 132
#DDS_UpdateOverlayDisplay         = 136
#DDS_UpdateOverlayZOrder          = 140
;    /*** Added in the v2 interface ***/
#DDS_GetDDInterface               = 144
#DDS_PageLock                     = 148
#DDS_PageUnlock                   = 152
;    /*** Added in the V3 interface ***/
#DDS_SetSurfaceDesc               = 156
;    /*** Added in the v4 interface ***/
#DDS_SetPrivateData               = 160
#DDS_GetPrivateData               = 164
#DDS_FreePrivateData              = 168
#DDS_GetUniquenessValue           = 172
#DDS_ChangeUniquenessValue        = 176
;    /*** Added in the v7 interface ***/
#DDS_SetPriority                  = 180
#DDS_GetPriority                  = 184
#DDS_SetLOD                       = 188
#DDS_GetLOD                       = 192



;*
;* IDirectDrawPalette
;*
#DDPalette_QueryInterface      = 0
#DDPalette_AddRef              = 4
#DDPalette_Release             = 8
#DDPalette_GetCaps             = 12
#DDPalette_GetEntries          = 16
#DDPalette_Initialize          = 20
#DDPalette_SetEntries          = 24



;*
;* IDirectDrawClipper
;*
#DDClipper_QueryInterface     = 0
#DDClipper_AddRef             = 4
#DDClipper_Release            = 8
#DDClipper_GetClipList        = 12
#DDClipper_GetHWnd            = 16
#DDClipper_Initialize         = 20
#DDClipper_IsClipListChanged  = 24
#DDClipper_SetClipList        = 28
#DDClipper_SetHWnd            = 32



;*
;* IDirectDrawColorControl
;*
#DDColorControl_QueryInterface    = 0
#DDColorControl_AddRef            = 4
#DDColorControl_Release           = 8
#DDColorControl_GetColorControls  = 12
#DDColorControl_SetColorControls  = 16


;*
;* IDirectDrawGammaControl
;*
#DDGammaControl_QueryInterface    = 0
#DDGammaControl_AddRef            = 4
#DDGammaControl_Release           = 8
#DDGammaControl_GetGammaRamp      = 12
#DDGammaControl_SetGammaRamp      = 16

 



;****************************************************************************
;*
;* DIRECTDRAW ERRORS
;*
;* Errors are represented by negative values and cannot be combined.
;*
;****************************************************************************
#CO_E_NOTINITIALIZED = $800401F0

;*
;* This object is already initialized
;*
#DDERR_ALREADYINITIALIZED                         = $88760005

;*
;* This surface can not be attached to the requested surface.
;*
#DDERR_CANNOTATTACHSURFACE                        = $8876000a

;*
;* This surface can not be detached from the requested surface.
;*
#DDERR_CANNOTDETACHSURFACE                        = $88760014

;*
;* Support is currently not available.
;*
#DDERR_CURRENTLYNOTAVAIL                          = $88760028

;*
;* An exception was encountered while performing the requested operation
;*
#DDERR_EXCEPTION                                  = $88760037

;*
;* Generic failure.
;*
#DDERR_GENERIC                                    = $80004005

;*
;* Height of rectangle provided is not a multiple of reqd alignment
;*
#DDERR_HEIGHTALIGN                                = $8876005a

;*
;* Unable to match primary surface creation request with existing
;* primary surface.
;*
#DDERR_INCOMPATIBLEPRIMARY                        = $8876005f

;*
;* One or more of the caps bits passed to the callback are incorrect.
;*
#DDERR_INVALIDCAPS                                = $88760064        ;( 100 )

;*
;* DirectDraw does not support provided Cliplist.
;*
#DDERR_INVALIDCLIPLIST                            = $8876006e        ;( 110 )

;*
;* DirectDraw does not support the requested mode
;*
#DDERR_INVALIDMODE                                = $88760078        ;( 120 )

;*
;* DirectDraw received a pointer that was an invalid DIRECTDRAW object.
;*
#DDERR_INVALIDOBJECT                              = $88760082        ;( 130 )

;*
;* One or more of the parameters passed to the callback function are
;* incorrect.
;*
#DDERR_INVALIDPARAMS                              = $80070057

;*
;* pixel format was invalid as specified
;*
#DDERR_INVALIDPIXELFORMAT                         = $88760091        ;( 145 )

;*
;* Rectangle provided was invalid.
;*
#DDERR_INVALIDRECT                                = $88760096        ;( 150 )

;*
;* Operation could not be carried out because one or more surfaces are locked
;*
#DDERR_LOCKEDSURFACES                             = $887600a0        ;( 160 )

;*
;* There is no 3D present.
;*
#DDERR_NO3D                                       = $887600aa        ;( 170 )

;*
;* Operation could not be carried out because there is no alpha accleration
;* hardware present or available.
;*
#DDERR_NOALPHAHW                                  = $887600b4        ;( 180 )

;*
;* Operation could not be carried out because there is no stereo
;* hardware present or available.
;*
#DDERR_NOSTEREOHARDWARE                           = $887600b5        ;( 181 )

;*
;* Operation could not be carried out because there is no hardware
;* present which supports stereo surfaces
;*
#DDERR_NOSURFACELEFT                              = $887600b6        ;( 182 )


;*
;* no clip list available
;*
#DDERR_NOCLIPLIST                                 = $887600cd        ;( 205 )

;*
;* Operation could not be carried out because there is no color conversion
;* hardware present or available.
;*
#DDERR_NOCOLORCONVHW                              = $887600d2        ;( 210 )

;*
;* Create function called without DirectDraw object method SetCooperativeLevel
;* being called.
;*
#DDERR_NOCOOPERATIVELEVELSET                      = $887600d4        ;( 212 )

;*
;* Surface doesn't currently have a color key
;*
#DDERR_NOCOLORKEY                                 = $887600d7        ;( 215 )

;*
;* Operation could not be carried out because there is no hardware support
;* of the dest color key.
;*
#DDERR_NOCOLORKEYHW                               = $887600dc        ;( 220 )

;*
;* No DirectDraw support possible with current display driver
;*
#DDERR_NODIRECTDRAWSUPPORT                        = $887600de        ;( 222 )

;*
;* Operation requires the application to have exclusive mode but the
;* application does not have exclusive mode.
;*
#DDERR_NOEXCLUSIVEMODE                            = $887600e1        ;( 225 )

;*
;* Flipping visible surfaces is not supported.
;*
#DDERR_NOFLIPHW                                   = $887600e6        ;( 230 )

;*
;* There is no GDI present.
;*
#DDERR_NOGDI                                      = $887600f0        ;( 240 )

;*
;* Operation could not be carried out because there is no hardware present
;* or available.
;*
#DDERR_NOMIRRORHW                                 = $887600fa        ;( 250 )

;*
;* Requested item was not found
;*
#DDERR_NOTFOUND                                   = $887600ff        ;( 255 )

;*
;* Operation could not be carried out because there is no overlay hardware
;* present or available.
;*
#DDERR_NOOVERLAYHW                                = $88760104        ;( 260 )

;*
;* Operation could not be carried out because the source and destination
;* rectangles are on the same surface and overlap each other.
;*
#DDERR_OVERLAPPINGRECTS                           = $8876010e        ;( 270 )

;*
;* Operation could not be carried out because there is no appropriate raster
;* op hardware present or available.
;*
#DDERR_NORASTEROPHW                               = $88760118        ;( 280 )

;*
;* Operation could not be carried out because there is no rotation hardware
;* present or available.
;*
#DDERR_NOROTATIONHW                               = $88760122        ;( 290 )

;*
;* Operation could not be carried out because there is no hardware support
;* for stretching
;*
#DDERR_NOSTRETCHHW                                = $88760136        ;( 310 )

;*
;* DirectDrawSurface is not in 4 bit color palette and the requested operation
;* requires 4 bit color palette.
;*
#DDERR_NOT4BITCOLOR                               = $8876013c        ;( 316 )

;*
;* DirectDrawSurface is not in 4 bit color index palette and the requested
;* operation requires 4 bit color index palette.
;*
#DDERR_NOT4BITCOLORINDEX                          = $8876013d        ;( 317 )

;*
;* DirectDraw Surface is not in 8 bit color mode and the requested operation
;* requires 8 bit color.
;*
#DDERR_NOT8BITCOLOR                               = $88760140        ;( 320 )

;*
;* Operation could not be carried out because there is no texture mapping
;* hardware present or available.
;*
#DDERR_NOTEXTUREHW                                = $8876014a        ;( 330 )

;*
;* Operation could not be carried out because there is no hardware support
;* for vertical blank synchronized operations.
;*
#DDERR_NOVSYNCHW                                  = $8876014f        ;( 335 )

;*
;* Operation could not be carried out because there is no hardware support
;* for zbuffer blting.
;*
#DDERR_NOZBUFFERHW                                = $88760154        ;( 340 )

;*
;* Overlay surfaces could not be z layered based on their BltOrder because
;* the hardware does not support z layering of overlays.
;*
#DDERR_NOZOVERLAYHW                               = $8876015e        ;( 350 )

;*
;* The hardware needed for the requested operation has already been
;* allocated.
;*
#DDERR_OUTOFCAPS                                  = $88760168        ;( 360 )

;*
;* DirectDraw does not have enough memory to perform the operation.
;*
#DDERR_OUTOFMEMORY                                = $8007000e

;*
;* DirectDraw does not have enough memory to perform the operation.
;*
#DDERR_OUTOFVIDEOMEMORY                           = $8876017c        ;( 380 )

;*
;* hardware does not support clipped overlays
;*
#DDERR_OVERLAYCANTCLIP                            = $8876017e        ;( 382 )

;*
;* Can only have ony color key active at one time for overlays
;*
#DDERR_OVERLAYCOLORKEYONLYONEACTIVE               = $88760180        ;( 384 )

;*
;* Access to this palette is being refused because the palette is already
;* locked by another thread.
;*
#DDERR_PALETTEBUSY                                = $88760183        ;( 387 )

;*
;* No src color key specified for this operation.
;*
#DDERR_COLORKEYNOTSET                             = $88760190        ;( 400 )

;*
;* This surface is already attached to the surface it is being attached to.
;*
#DDERR_SURFACEALREADYATTACHED                     = $8876019a        ;( 410 )

;*
;* This surface is already a dependency of the surface it is being made a
;* dependency of.
;*
#DDERR_SURFACEALREADYDEPENDENT                    = $887601a4        ;( 420 )

;*
;* Access to this surface is being refused because the surface is already
;* locked by another thread.
;*
#DDERR_SURFACEBUSY                                = $887601ae        ;( 430 )

;*
;* Access to this surface is being refused because no driver exists
;* which can supply a pointer to the surface.
;* This is most likely to happen when attempting to lock the primary
;* surface when no DCI provider is present.
;* Will also happen on attempts to lock an optimized surface.
;*
#DDERR_CANTLOCKSURFACE                            = $887601b3        ;( 435 )

;*
;* Access to Surface refused because Surface is obscured.
;*
#DDERR_SURFACEISOBSCURED                          = $887601b8        ;( 440 )

;*
;* Access to this surface is being refused because the surface is gone.
;* The DIRECTDRAWSURFACE object representing this surface should
;* have Restore called on it.
;*
#DDERR_SURFACELOST                                = $887601c2        ;( 450 )

;*
;* The requested surface is not attached.
;*
#DDERR_SURFACENOTATTACHED                         = $887601cc        ;( 460 )

;*
;* Height requested by DirectDraw is too large.
;*
#DDERR_TOOBIGHEIGHT                               = $887601d6        ;( 470 )

;*
;* Size requested by DirectDraw is too large --  The individual height and
;* width are OK.
;*
#DDERR_TOOBIGSIZE                                 = $887601e0        ;( 480 )

;*
;* Width requested by DirectDraw is too large.
;*
#DDERR_TOOBIGWIDTH                                = $887601ea        ;( 490 )

;*
;* Action not supported.
;*
#DDERR_UNSUPPORTED                                = $80004001

;*
;* Pixel format requested is unsupported by DirectDraw
;*
#DDERR_UNSUPPORTEDFORMAT                          = $887601fe

;*
;* Bitmask in the pixel format requested is unsupported by DirectDraw
;*
#DDERR_UNSUPPORTEDMASK                            = $88760208

;*
;* The specified stream contains invalid data
;*
#DDERR_INVALIDSTREAM                              = $88760209        ;( 521 )

;*
;* vertical blank is in progress
;*
#DDERR_VERTICALBLANKINPROGRESS                    = $88760219        ;( 537 )

;*
;* Informs DirectDraw that the previous Blt which is transfering information
;* to or from this Surface is incomplete.
;*
#DDERR_WASSTILLDRAWING                            = $8876021c        ;( 540 )


;*
;* The specified surface type requires specification of the COMPLEX flag
;*
#DDERR_DDSCAPSCOMPLEXREQUIRED                     = $8876021e        ;( 542 )


;*
;* Rectangle provided was not horizontally aligned on reqd. boundary
;*
#DDERR_XALIGN                                     = $88760230        ;( 560 )

;*
;* The GUID passed to DirectDrawCreate is not a valid DirectDraw driver
;* identifier.
;*
#DDERR_INVALIDDIRECTDRAWGUID                      = $88760231        ;( 561 )

;*
;* A DirectDraw object representing this driver has already been created
;* for this process.
;*
#DDERR_DIRECTDRAWALREADYCREATED                   = $88760232        ;( 562 )

;*
;* A hardware only DirectDraw object creation was attempted but the driver
;* did not support any hardware.
;*
#DDERR_NODIRECTDRAWHW                             = $88760233        ;( 563 )

;*
;* this process already has created a primary surface
;*
#DDERR_PRIMARYSURFACEALREADYEXISTS                = $88760234        ;( 564 )

;*
;* software emulation not available.
;*
#DDERR_NOEMULATION                                = $88760235        ;( 565 )

;*
;* region passed to Clipper::GetClipList is too small.
;*
#DDERR_REGIONTOOSMALL                             = $88760236        ;( 566 )

;*
;* an attempt was made to set a clip list for a clipper objec that
;* is already monitoring an hwnd.
;*
#DDERR_CLIPPERISUSINGHWND                         = $88760237        ;( 567 )

;*
;* No clipper object attached to surface object
;*
#DDERR_NOCLIPPERATTACHED                          = $88760238        ;( 568 )

;*
;* Clipper notification requires an HWND or
;* no HWND has previously been set as the CooperativeLevel HWND.
;*
#DDERR_NOHWND                                     = $88760239        ;( 569 )

;*
;* HWND used by DirectDraw CooperativeLevel has been subclassed,
;* this prevents DirectDraw from restoring state.
;*
#DDERR_HWNDSUBCLASSED                             = $8876023a        ;( 570 )

;*
;* The CooperativeLevel HWND has already been set.
;* It can not be reset while the process has surfaces or palettes created.
;*
#DDERR_HWNDALREADYSET                             = $8876023b        ;( 571 )

;*
;* No palette object attached to this surface.
;*
#DDERR_NOPALETTEATTACHED                          = $8876023c        ;( 572 )

;*
;* No hardware support for 16 or 256 color palettes.
;*
#DDERR_NOPALETTEHW                                = $8876023d        ;( 573 )

;*
;* If a clipper object is attached to the source surface passed into a
;* BltFast call.
;*
#DDERR_BLTFASTCANTCLIP                            = $8876023e        ;( 574 )

;*
;* No blter.
;*
#DDERR_NOBLTHW                                    = $8876023f        ;( 575 )

;*
;* No DirectDraw ROP hardware.
;*
#DDERR_NODDROPSHW                                 = $88760240        ;( 576 )

;*
;* returned when GetOverlayPosition is called on a hidden overlay
;*
#DDERR_OVERLAYNOTVISIBLE                          = $88760241        ;( 577 )

;*
;* returned when GetOverlayPosition is called on a overlay that UpdateOverlay
;* has never been called on to establish a destionation.
;*
#DDERR_NOOVERLAYDEST                              = $88760242        ;( 578 )

;*
;* returned when the position of the overlay on the destionation is no longer
;* legal for that destionation.
;*
#DDERR_INVALIDPOSITION                            = $88760243        ;( 579 )

;*
;* returned when an overlay member is called for a non-overlay surface
;*
#DDERR_NOTAOVERLAYSURFACE                         = $88760244        ;( 580 )

;*
;* An attempt was made to set the cooperative level when it was already
;* set to exclusive.
;*
#DDERR_EXCLUSIVEMODEALREADYSET                    = $88760245        ;( 581 )

;*
;* An attempt has been made to flip a surface that is not flippable.
;*
#DDERR_NOTFLIPPABLE                               = $88760246        ;( 582 )

;*
;* Can't duplicate primary & 3D surfaces, or surfaces that are implicitly
;* created.
;*
#DDERR_CANTDUPLICATE                              = $88760247        ;( 583 )

;*
;* Surface was not locked.  An attempt to unlock a surface that was not
;* locked at all, or by this process, has been attempted.
;*
#DDERR_NOTLOCKED                                  = $88760248        ;( 584 )

;*
;* Windows can not create any more DCs, or a DC was requested for a paltte-indexed
;* surface when the surface had no palette AND the display mode was not palette-indexed
;* (in this case DirectDraw cannot select a proper palette into the DC)
;*
#DDERR_CANTCREATEDC                               = $88760249        ;( 585 )

;*
;* No DC was ever created for this surface.
;*
#DDERR_NODC                                       = $8876024a        ;( 586 )

;*
;* This surface can not be restored because it was created in a different
;* mode.
;*
#DDERR_WRONGMODE                                  = $8876024b        ;( 587 )

;*
;* This surface can not be restored because it is an implicitly created
;* surface.
;*
#DDERR_IMPLICITLYCREATED                          = $8876024c        ;( 588 )

;*
;* The surface being used is not a palette-based surface
;*
#DDERR_NOTPALETTIZED                              = $8876024d        ;( 589 )


;*
;* The display is currently in an unsupported mode
;*
#DDERR_UNSUPPORTEDMODE                            = $8876024e        ;( 590 )

;*
;* Operation could not be carried out because there is no mip-map
;* texture mapping hardware present or available.
;*
#DDERR_NOMIPMAPHW                                 = $8876024f        ;( 591 )

;*
;* The requested action could not be performed because the surface was of
;* the wrong type.
;*
#DDERR_INVALIDSURFACETYPE                         = $88760250        ;( 592 )

;*
;* Device does not support optimized surfaces, therefore no video memory optimized surfaces
;*
#DDERR_NOOPTIMIZEHW                               = $88760258        ;( 600 )

;*
;* Surface is an optimized surface, but has not yet been allocated any memory
;*
#DDERR_NOTLOADED                                  = $88760259        ;( 601 )

;*
;* Attempt was made to create or set a device window without first setting
;* the focus window
;*
#DDERR_NOFOCUSWINDOW                              = $8876025a        ;( 602 )

;*
;* Attempt was made to set a palette on a mipmap sublevel
;*
#DDERR_NOTONMIPMAPSUBLEVEL                        = $8876025b        ;( 603 )

;*
;* A DC has already been returned for this surface. Only one DC can be
;* retrieved per surface.
;*
#DDERR_DCALREADYCREATED                           = $8876026c        ;( 620 )

;*
;* An attempt was made to allocate non-local video memory from a device
;* that does not support non-local video memory.
;*
#DDERR_NONONLOCALVIDMEM                           = $88760276        ;( 630 )

;*
;* The attempt to page lock a surface failed.
;*
#DDERR_CANTPAGELOCK                               = $88760280        ;( 640 )


;*
;* The attempt to page unlock a surface failed.
;*
#DDERR_CANTPAGEUNLOCK                             = $88760294        ;( 660 )

;*
;* An attempt was made to page unlock a surface with no outstanding page locks.
;*
#DDERR_NOTPAGELOCKED                              = $887602a8        ;( 680 )

;*
;* There is more data available than the specified buffer size could hold
;*
#DDERR_MOREDATA                                   = $887602b2        ;( 690 )

;*
;* The data has expired and is therefore no longer valid.
;*
#DDERR_EXPIRED                                    = $887602b3        ;( 691 )

;*
;* The mode test has finished executing.
;*
#DDERR_TESTFINISHED                               = $887602b4        ;( 692 )

;*
;* The mode test has switched to a new mode.
;*
#DDERR_NEWMODE                                    = $887602b5        ;( 693 )

;*
;* D3D has not yet been initialized.
;*
#DDERR_D3DNOTINITIALIZED                          = $887602b6        ;( 694 )

;*
;* The video port is not active
;*
#DDERR_VIDEONOTACTIVE                             = $887602b7        ;( 695 )

;*
;* The monitor does not have EDID data.
;*
#DDERR_NOMONITORINFORMATION                       = $887602b8        ;( 696 )

;*
;* The driver does not enumerate display mode refresh rates.
;*
#DDERR_NODRIVERSUPPORT                            = $887602b9        ;( 697 )

;*
;* Surfaces created by one direct draw device cannot be used directly by
;* another direct draw device.
;*
#DDERR_DEVICEDOESNTOWNSURFACE                     = $887602bb        ;( 699 )



;*
;* An attempt was made to invoke an interface member of a DirectDraw object
;* created by CoCreateInstance() before it was initialized.
;*
#DDERR_NOTINITIALIZED                             = #CO_E_NOTINITIALIZED 
; ExecutableFormat=Windows
; EOF