;
; DirectX 7 sprite z00m, by Danilo, March 2002
;
#ScreenResX = 640
#ScreenResY = 480
#ScreenBits = 32

; Structures and Constants
;
IncludeFile "DDRAW.pb"

;
; Begin Code
;
#PixelSize = ( #ScreenBits / 8 )

DD.l
ddsd.DDSURFACEDESC2
lpDDSPrimary.l
lpDDSBack.l
lpDDSOne.l

hWnd = OpenWindow(1,100,100,300,400,#WS_POPUP,"DX-TEST")
SetFocus_(hWnd)

If OpenLibrary(0,"ddraw.dll")
 If CallFunction(0,"DirectDrawCreateEx",0,@DD,?IID_IDirectDraw7,0) <> #DD_OK
   MessageRequester("Warning:","Couldn't init DirectDraw",0):End:EndIf
Else
   MessageRequester("Warning:","Couldn't init DirectDraw",0):End:
EndIf


If CallDX(#dd_SetCooperativeLevel,DD,hWnd,#DDSCL_EXCLUSIVE | #DDSCL_FULLSCREEN) <> #DD_OK
   MessageRequester("Warning:","Couldn't set DirectDraw cooperative level",0):End:EndIf

If CallDX(#dd_SetDisplayMode,DD,#ScreenResX,#ScreenResY,#ScreenBits,0,0) <> #DD_OK
   MessageRequester("Warning:","Couldn't set display mode",0):End:EndIf

 ;
 ; CHANGED for DOUBLEBUFFER
 ;
 ddsd\dwSize = SizeOf(DDSURFACEDESC2)
 ddsd\dwFlags = #DDSD_CAPS | #DDSD_BACKBUFFERCOUNT
 ddsd\ddsCaps\dwCaps = #DDSCAPS_PRIMARYSURFACE | #DDSCAPS_FLIP | #DDSCAPS_COMPLEX
 ddsd\dwBackBufferCount = 1

If CallDX(#dd_CreateSurface,DD,ddsd,@lpDDSPrimary,0) <> #DD_OK
   MessageRequester("Warning:","Couldn't create primary surface",0):End:EndIf

    ddscaps.DDSCAPS2
    ;Get a pointer To the back buffer
    ddscaps\dwCaps = #DDSCAPS_BACKBUFFER;
    If CallDX(#dds_GetAttachedSurface, lpDDSPrimary, ddscaps, @lpDDSBack) <> #DD_OK
      beep_(1000,1000): End : EndIf

;
; LOAD the image and create a surface
;
    ;// Create the offscreen surface, by loading our bitmap.
    hbm.l                   ;HBITMAP
    bm.BITMAP               ;BITMAP
    SPRITEddsd.DDSURFACEDESC2;
    pdds.l;

    hbm = LoadImage_(0, "Sprite.bmp", #IMAGE_BITMAP, 0, 0, #LR_LOADFROMFILE | #LR_CREATEDIBSECTION);
    If hbm = 0
        MessageRequester("INFO","Couldn't load the Sprite",0):End:EndIf

    GetObject_(hbm, SizeOf(BITMAP), bm);

    SPRITEddsd\dwSize = SizeOf(DDSURFACEDESC2);
    SPRITEddsd\dwFlags = #DDSD_CAPS | #DDSD_HEIGHT | #DDSD_WIDTH;
    SPRITEddsd\ddsCaps\dwCaps = #DDSCAPS_OFFSCREENPLAIN;
    SPRITEddsd\dwWidth = bm\bmWidth;
    SPRITEddsd\dwHeight = bm\bmHeight;
    If CallDX(#dd_CreateSurface,DD,SPRITEddsd,@pdds,0) <> #DD_OK
       MessageRequester("Warning:","Couldn't create Sprite surface",0):End:EndIf

    hdcImage.l;.HDC;
    hdc.l;.HDC;
    bm2.BITMAP;
    ddsd2.DDSURFACEDESC2;
    hr.l;

    hdcImage = CreateCompatibleDC_(0);
    If hdcImage = 0
        MessageRequester("INFO","createcompatible dc failed",0):End:EndIf
    SelectObject_(hdcImage, hbm);
    GetObject_(hbm, SizeOf(BITMAP), bm2);
    dx = bm2\bmWidth
    dy = bm2\bmHeight
    ddsd2\dwSize = SizeOf(DDSURFACEDESC2);
    ddsd2\dwFlags = #DDSD_HEIGHT | #DDSD_WIDTH;
    CallDX(#dds_GetSurfaceDesc, pdds, @ddsd2);

    hr = CallDX(#dds_GetDC, pdds, @hdc)
    If hr = #DD_OK
        StretchBlt_(hdc, 0, 0, ddsd2\dwWidth, ddsd2\dwHeight, hdcImage, 0, 0, dx, dy, #SRCCOPY);
        CallDX(#dds_ReleaseDC, pdds, hdc);
    Else
      Beep_(1000,1000)
    EndIf
    DeleteDC_(hdcImage);
    DeleteObject_(hbm);
    lpDDSOne = pdds;

    If lpDDSOne = 0
     MessageRequester("INFO","DDLoadBitmap FAILED",0):End:EndIf

    ddck.DDCOLORKEY;
    ddck\dwColorSpaceLowValue = 0;
    ddck\dwColorSpaceHighValue = 0;
    CallDX(#dds_SetColorKey, lpDDSOne, #DDCKEY_SRCBLT, ddck);
;
; OK, Image is now loaded (hopefully ;)
;


ShowWindow_(hWnd, #SW_SHOW)
ShowCursor_(0)
;beep_(1000,1000)
MessageRequester("INFO","Der TEST beginnt",0)
;DXtest(hWnd)
;
; Message-Loop
;

Color.l = $00FFFF00

  Repeat
    EventID.l = WindowEvent()
    If EventID = #PB_EventCloseWindow  ; If the user has pressed on the close button
      Quit = 1
    EndIf

    If GetFocus_() = hWnd


       ; FLIP !!!
       CallDX(#dds_FLIP, lpDDSPrimary, 0, #DDFLIP_WAIT)



       ;beep_(600,1)
       ddsd\dwSize = SizeOf(DDSURFACEDESC2)
       ddsd\dwFlags = #DDSD_PITCH
       lockreturn = CallDX(#dds_LOCK, lpDDSBack, 0, ddsd, #DDLOCK_WAIT,0)
       If lockreturn = #DD_OK
         *screen = ddsd\lpSurface
         Gosub ClearScreen 
         CallDX(#dds_UNLOCK, lpDDSBack, 0)


       Else
         If lockreturn = #DDERR_SURFACELOST
             CallDX(#dds_RESTORE, lpDDSBack)
             CallDX(#dds_RESTORE, lpDDSPrimary)
             CallDX(#dds_RESTORE, lpDDSOne)
         Else
             MessageRequester("ERROR", "Couldn't lock surface",0):End
         EndIf

       EndIf

    rcRect.RECT
    rcRect\left = 0;
    rcRect\top = 0;
    rcRect\right = 640;
    rcRect\bottom = 480;
    CallDX( #dds_BltFast,lpDDSBack, 0, 0, lpDDSOne, rcRect, #DDBLTFAST_NOCOLORKEY);

    ;For (i = 0; i < 3; i++)
    ;{
    ;    rcRect.left = currentFrame[i] % 10 * 64;
    ;    rcRect.top = currentFrame[i] / 10 * 64 + 480;
    ;    rcRect.right = currentFrame[i] % 10 * 64 + 64;
    ;    rcRect.bottom = currentFrame[i] / 10 * 64 + 64 + 480;
    


    rcRect\left = 0 ;
    rcRect\top = 480;
    rcRect\right = 64;
    rcRect\bottom = 480+64;

    ddbltfx.DDBLTFX
    ddbltfx\dwSize = SizeOf(DDBLTFX)


    destRECT.RECT
    destRECT\left = 100
    destRECT\top = 100
    destRECT\right = 100+myX
    destRECT\bottom = 100+myX

    ;CallDX5( #dds_BltFast,lpDDSBack, myX, 100, lpDDSOne, rcRect, #DDBLTFAST_SRCCOLORKEY);
    CallDX( #dds_Blt,lpDDSBack, destRECT, lpDDSOne, rcRect, #DDBLT_KEYSRC ,ddbltfx);


    myX + 1
    If myX > 300: myX = 10: EndIf

    EndIf
    
    ;WaitWindowEvent()

  

  Until Quit = 1 

End

ClearScreen:
  For a = 0 To #ScreenResX*#ScreenResY*#PixelSize Step 4
   PokeL(*screen + a,0) ; RGB
  Next a
 Return
 
DataSection
  IID_IDirectDraw7:
    Data.l $15e65ec0
    Data.w $3b9c, $11d2
    Data.b $b9, $2f, $00, $60, $97, $97, $ea, $5b
EndDataSection 
; ExecutableFormat=Windows
; Executable=z00m.exe
; DisableDebugger
; EOF