;-----------------------------------
; PureGL: written by Danilo,       -
;         24.August 2002           -
;-----------------------------------
;-----------------------------------
;--[ START ]------------------------
;-----------------------------------
;-----------------------------------
; Include
IncludeFile "OpenGL.pbi"

; Variables
Global OpenGLview_MainWnd.l, OpenGLview_subWnd, OpenGLview_GadgetWin, OpenGLview_hInstance
Global hDC, hRC
Global z.f, xspeed.f, yspeed.f, xrot.f, yrot.f, filter
Global object, quadratic
Global p1, p2, part1, part2

Global TextureFile.s
TextureFile.s = "wallpaper.bmp"
filter = 2

Dim LightAmbient.f(4)
Dim LightDiffuse.f(4)
Dim LightPosition.f(4)

Dim baImageData.l(1)
Dim texture.l(3)

; Procedures
Declare.l CreateGLWindow(Width.l, Height.l, BPP.l, Title.s)
Declare   KillGLWindow()
Declare   ReSizeGLScene(width, height)
Declare.l InitGL()
Declare   LoadGLtextures()
Declare.l  LoadBMP(Filename$)
Declare   DrawGLscene()
Declare   DrawCube()
Declare   DrawCube2()
Declare.l  WindowResizeManager()

p1 = 0
p2 = 1
object = 0
    
    If CreateGLWindow(640, 480, 16, "PureGL by Danilo") = #FALSE
        Quit = 1 : KillGLWindow()
      Else
        While WindowEvent():Wend
    EndIf

    While done = 0
         Event = WindowEvent()
         StartTime = TimeGetTime_()
         Select Event
            Case #PB_EventGadget
                 Select EventGadgetID()
                   Case 2 : object - 1 : If object < 0 : object = 5 : EndIf  ; OBJECT
                   Case 3 : object + 1 : If object > 5 : object = 0 : EndIf
                   Case 5 : z = GetGadgetState(5)/10 -10: SetGadgetText(6,StrF(z))
                   Case 8 : xspeed - 1.01                                     ; X
                   Case 9 : xspeed + 1.01
                   Case 11: yspeed - 1.01                                     ; Y
                   Case 12: yspeed + 1.01
                   Case 14: filter - 1 : If filter < 0 : filter = 0 : EndIf : SetGadgetText(16,Str(filter))
                   Case 15: filter + 1 : If filter > 2 : filter = 2 : EndIf : SetGadgetText(16,Str(filter))
                   Case 17: done = 1
                   Case 18: SetWindowPos_(OpenGLview_MainWnd, #HWND_TOP, 0, 0, 0, 0, #SWP_NOMOVE | #SWP_NOSIZE)
                            MessageRequester("PROGRAM INFO","NeHe & TipTup's Quadratics Tutorial 18"+"  ( see   http://NeHe.GameDev.net   for more Info )"+Chr(13)+Chr(13)+"Converted to PureBasic ( www.PureBasic.com ) and added a little GUI:   Danilo , 24.August 2002",#MB_ICONINFORMATION)
                            SetWindowPos_(OpenGLview_MainWnd, #HWND_TOPMOST, 0, 0, 0, 0, #SWP_NOMOVE | #SWP_NOSIZE)
                   Case 19: xspeed = 0.0 : yspeed = 0.0
                EndSelect: SetFocus_(OpenGLview_subWnd)
                UseWindow(1):ActivateWindow()
                While WindowEvent():Wend
            Case #PB_EventCloseWindow
                 done = 1
         EndSelect
         DrawGLscene()
         SwapBuffers_(hDC)
         Delay(1)
         ;While TimeGetTime_() - StartTime < 20: sleep_(1):Wend
    Wend
    
KillGLWindow()
End
;-----------------------------------
;-----------------------------------
;--[ END ]--------------------------
;-----------------------------------
;-----------------------------------

Procedure.l CreateGLWindow(Width.l, Height.l, BPP.l, Title.s)
        
   OpenGLview_MainWnd = OpenWindow(1,GetSystemMetrics_(#SM_CXSCREEN)/2-Width+70/2,GetSystemMetrics_(#SM_CYSCREEN)/2-Height/2,Width+70,Height,#PB_Window_SizeGadget,Title)

   OpenGLview_GadgetWin = OpenWindow(2,Width-2,-1,74,Height,#WS_POPUP|#WS_BORDER,"")
   SetParent_(OpenGLview_GadgetWin, OpenGLview_MainWnd)
   CreateGadgetList(WindowID())
        TextGadget(1,0,10,70,20,"OBJECT",#PB_Text_Center)
        ButtonGadget(2,15,30,20,20,"-")
        ButtonGadget(3,35,30,20,20,"+")
        
        TextGadget(4,0,220,70,20,"ZOOM: Z",#PB_Text_Center)
        TrackBarGadget(5, 0, 240, 70, 29, 0, 100) 
        SetGadgetState(5, 50):z = GetGadgetState(5)/10 -9
        TextGadget(6,0,270,70,20,StrF(z),#PB_Text_Center)

        TextGadget(7,0,70,70,20,"SPEED: X",#PB_Text_Center)
        ButtonGadget(8,15,90,20,20,"-")
        ButtonGadget(9,35,90,20,20,"+")

        TextGadget(10,0,130,70,20,"SPEED: Y",#PB_Text_Center)
        ButtonGadget(11,15,150,20,20,"-")
        ButtonGadget(12,35,150,20,20,"+")
        
        TextGadget(13,0,310,70,40,"Texture Quality",#PB_Text_Center)
        ButtonGadget(14,15,340,20,20,"-")
        ButtonGadget(15,35,340,20,20,"+")
        TextGadget(16,0,365,70,20,Str(filter),#PB_Text_Center)
        
        ButtonGadget(17,0,400,72,20,"Quit")
        ButtonGadget(18,0,420,72,20,"About")
        ButtonGadget(19,0,185,72,20,"Stop Speed")
        While WindowEvent():Wend
   SetWindowCallback(@WindowResizeManager())


   #GL_Style  = #WS_CHILD|#WS_CLIPSIBLINGS|#WS_CLIPCHILDREN|#WS_VISIBLE|#WS_BORDER
   #GL_XStyle = #WS_EX_OVERLAPPEDWINDOW
   !MOV dword EAX, [_PB_Instance]
   !MOV dword [v_OpenGLview_hInstance], EAX  ; Get application instance

   class$ = "PureGL"

   wc.WNDCLASSEX
   wc\cbSize        = SizeOf(WNDCLASSEX)
   wc\style         = 0
   wc\lpfnWndProc   = GetWindowLong_(OpenGLview_MainWnd,#GWL_WNDPROC) 
   wc\cbClsExtra    = 0 
   wc\cbWndExtra    = 0 
   wc\hInstance     = OpenGLview_hInstance
   wc\hIcon         = 0 
   wc\hCursor       = LoadCursor_(0, #IDC_CROSS)  ; #IDC_ARROW   = Arrow
                                                  ; #IDC_SIZEALL = Size Arrow
                                                  ; #IDC_CROSS   = Cross
   wc\hbrBackground = CreateSolidBrush_(0)  ; RGB($8F,$8F,$8F)
   wc\lpszMenuName  = 0
   wc\lpszClassName = @class$
   wc\hIconSm       = 0
   RegisterClassEx_(@wc)

   OpenGLview_subWnd = CreateWindowEx_( #GL_XStyle,class$,"",#GL_Style,0,0,width,height,OpenGLview_MainWnd,0,OpenGLview_hInstance,0)
       
   pfd.PIXELFORMATDESCRIPTOR
   pfd\nSize = SizeOf(PIXELFORMATDESCRIPTOR)
   pfd\nVersion = 1
   pfd\dwFlags = #PFD_DRAW_TO_WINDOW | #PFD_SUPPORT_OPENGL | #PFD_DOUBLEBUFFER
   pfd\iPixelType = #PFD_TYPE_RGBA
   pfd\cColorBits = BPP
   pfd\cDepthBits = 16
   pfd\iLayerType = #PFD_MAIN_PLANE
    
   hDC = GetDC_(OpenGLview_subWnd)
   SetPixelFormat_(hdc,ChoosePixelFormat_(hdc,pfd),pfd)
   hRC = wglCreateContext_(hDC)
   wglMakeCurrent_(hDC, hRC)

   glShadeModel_ (#GL_SMOOTH)
   glEnable_ (#GL_CULL_FACE)    ; This will enhance the rendering speed as all the back face will be
                                ; ignored. This works only with CLOSED objects like a cube... Singles
                                ; planes surfaces will be visibles only on one side. 

   UpdateWindow_(OpenGLview_subWnd)
   SetWindowPos_(OpenGLview_MainWnd, #HWND_TOPMOST, 0, 0, 0, 0, #SWP_NOMOVE | #SWP_NOSIZE)
   SetFocus_(OpenGLview_subWnd)
   ReSizeGLScene(width,height)
   InitGL()
    
   ProcedureReturn #True
EndProcedure


Procedure KillGLWindow()
   wglMakeCurrent_(0, 0)
   wglDeleteContext_(hRC)
   ReleaseDC_(OpenGLview_subWnd, hDC)
   CloseWindow(1)
   UnregisterClass_("PureGL", OpenGLview_hInstance)
   End
EndProcedure


Procedure ReSizeGLScene(width, height)
    If height = 0 : height = 1 : EndIf
    glViewport_(0,0,width,height)
    glMatrixMode_(#GL_Projection)
    glLoadIdentity_()
    gluPerspectivef_( 80.0, width / height, 0.1, 100.0)
    glMatrixMode_(#GL_ModelView)
    glLoadIdentity_()
EndProcedure


Procedure.l InitGL()
    LoadGLTextures()

    glEnable_(#GL_Texture_2D)
    glShadeModel_(#GL_Smooth)
    glClearColor_(0, 0, 0, 0.4)

    glDepthFunc_(#GL_Equal)
    glHint_(#GL_Perspective_Correction_Hint, #GL_Nicest)

    glEnable_(#GL_LIGHTING)
    LightAmbient(0)  = 0.5 : LightAmbient(1)  = 0.5 : LightAmbient(2)  = 0.5 : LightAmbient(3)  = 1
    LightDiffuse(0)  = 1   : LightDiffuse(1)  = 1   : LightDiffuse(2)  = 1   : LightDiffuse(3)  = 1
    LightPosition(0) = 0   : LightPosition(1) = 0   : LightPosition(2) = 2   : LightPosition(3) = 1

    glLightfv_(#GL_Light1, #GL_Ambient, LightAmbient())
    glLightfv_(#GL_Light1, #GL_Diffuse, LightDiffuse())
    glLightfv_(#GL_Light1, #GL_Position,LightPosition())
    glEnable_(#GL_Light1)

    quadratic = gluNewQuadric_()
    #GLU_SMOOTH = 100000
    gluQuadricNormals_(quadratic, #GLU_Smooth)
    gluQuadricTexture_(quadratic, #GL_TRUE)
    
    ProcedureReturn #True
EndProcedure


Procedure LoadGLTextures()
    *bmpdata = LoadBMP(TextureFile.s)
     width   = PeekL(*bmpdata)
     height  = PeekL(*bmpdata+4)
    
    glGenTextures_(3, @texture(0))

    glBindTexture_(#GL_Texture_2D, texture(0))
    glTexParameteri_(#GL_Texture_2D, #GL_Texture_Mag_Filter, #GL_NEAREST)
    glTexParameteri_(#GL_Texture_2D, #GL_Texture_Min_Filter, #GL_NEAREST)
    glTexImage2D_(#GL_Texture_2D, 0, 3, width, height, 0, #GL_BGR_Ext, #GL_UNSIGNED_BYTE, @baImageData(0))

    glBindTexture_(#GL_Texture_2D, texture(1))
    glTexParameteri_(#GL_Texture_2D, #GL_Texture_Mag_Filter, #GL_LINEAR)
    glTexParameteri_(#GL_Texture_2D, #GL_Texture_Min_Filter, #GL_LINEAR)
    glTexImage2D_(#GL_Texture_2D, 0, 3, width, height, 0, #GL_BGR_Ext, #GL_UNSIGNED_BYTE, @baImageData(0))

    glBindTexture_(#GL_Texture_2D, texture(2))
    glTexParameteri_(#GL_Texture_2D, #GL_Texture_Mag_Filter, #GL_LINEAR)
    glTexParameteri_(#GL_Texture_2D, #GL_Texture_Min_Filter, #GL_LINEAR_MIPMAP_NEAREST)
    gluBuild2DMipmaps_(#GL_Texture_2D, 3, width, height, #GL_BGR_Ext, #GL_UNSIGNED_BYTE, @baImageData(0))

    Dim baImageData(0)
EndProcedure


Procedure.l LoadBMP(Filename$)
   Structure ReturnSize
      Width.l
      Height.l
   EndStructure
   Shared giveBack.ReturnSize
  
   ; Open the file
   CheckFilename:
   If Filename$ = ""
      Filename$ = OpenFileRequester("CHOOSE TEXTURE (24bit .BMP)","","24 bit .BMP|*.bmp",0)
      Goto CheckFilename
   EndIf
      If ReadFile(1, Filename$)
         BitmapMem = AllocateMemory(1,Lof(),0)
            ReadData(BitmapMem,Lof())
         CloseFile(1)
      Else
         CloseFile(1)
         MessageRequester("ERROR","Cant open Texture File",#MB_ICONWARNING)
         Filename$ = ""
         Goto CheckFilename
      EndIf

   A$ = PeekS(BitmapMem,2)
   If A$ <> "BM": Goto CheckFilename : EndIf

   ; Determine how many colors are used
   If PeekW(BitmapMem+$1C) <> 24
       MessageRequester("ERROR","Not a 24 bit BMP !!",#MB_ICONWARNING)
       Filename$ = ""
       Goto CheckFilename
   EndIf

   ; Determine how big the image is
   x = PeekW(BitmapMem+$1C) / 8
   iPixelSize = x
  
   ; Resize array To fit image Data size
   lImageSize = PeekL(BitmapMem+$12) * PeekL(BitmapMem+$16) * iPixelSize
       Dim baImageData(lImageSize)
       x = 14 + PeekL(BitmapMem+$0E) + (colorcount*4)
       ; Read in the image Data
       CopyMemory(BitmapMem+x,@baImageData(0),lImageSize)
       giveBack\Width  = PeekL(BitmapMem+$12)
       giveBack\Height = PeekL(BitmapMem+$16)
   FreeMemory(1)
   ProcedureReturn @giveBack
EndProcedure


Procedure DrawGLScene()
    glClear_(#GL_Color_Buffer_Bit | #GL_Depth_Buffer_Bit)
    glLoadIdentity_()
    glTranslatef_( 0, 0, z)
    a.f = 1.01
    b.f = 1.01
    glRotatef_(xrot, a.f, 0, 0)
    glRotatef_(yrot, 0, b.f, 0)

    glBindTexture_(#GL_Texture_2D, texture(filter))

    Select object
        Case 0:
            DrawCube2()  ; use Workaround for PB 3.30
        Case 1:
            a.f = -1.5
            glTranslatef_( 0, 0, a.f)
            gluCylinderf_( quadratic, 1, 1, 3, 32, 32)
        Case 2:
            gluDiskf_( quadratic, 0.5, 1.5, 32, 32)
        Case 3:
            gluSpheref_( quadratic, 1.3, 32, 32)
        Case 4:
            a.f = -1.5
            glTranslatef_( 0, 0, a)
            gluCylinderf_( quadratic, 1, 0, 3, 32, 32)
        Case 5:
            part1 = part1 + p1
            part2 = part2 + p2
   
            If part1 > 359
                p1 = 0
                part1 = 0
                p2 = 1
                part2 = 0
            EndIf
            If part2 > 359
                p1 = 1
                p2 = 0
            EndIf
            gluPartialDiskf_( quadratic, 0.5, 1.5, 32, 32, part1, part2 - part1)
    EndSelect

    xrot = xrot + xspeed
    yrot = yrot + yspeed
EndProcedure


Procedure DrawCube2()
;
; Workaround for PB 3.30 bug : use Variables for this floats (already fixed for 3.40!!)
;
    glBegin_(#GL_Quads)
        ;' Front Face
        One.f = 1.0
        Null.f = 0.0
        Minus.f = -1.0
        glNormal3f_( null, null, one )
        glTexCoord2f_( null, null ) : glVertex3f_( minus,minus, one )
        glTexCoord2f_( one, null ) : glVertex3f_(  one,minus, one )
        glTexCoord2f_( one, one ) : glVertex3f_(  one, one, one )
        glTexCoord2f_( null, one ) : glVertex3f_( minus, one, one )
        ;' Back Face
        glNormal3f_( null, null,minus )
        glTexCoord2f_( one, null ) : glVertex3f_( minus,minus,minus )
        glTexCoord2f_( one, one ) : glVertex3f_( minus, one,minus )
        glTexCoord2f_( null,one ) : glVertex3f_(  one, one,minus )
        glTexCoord2f_( null, null ) : glVertex3f_(  one,minus,minus )
        ;' Top Face
        glNormal3f_( null, one, null )
        glTexCoord2f_( null, one ) : glVertex3f_( minus, one, minus )
        glTexCoord2f_( null, null ) : glVertex3f_( minus, one, one )
        glTexCoord2f_( one, null ) : glVertex3f_(  one, one, one )
        glTexCoord2f_( one, one ) : glVertex3f_(  one, one,minus )
        ;' Bottom Face
        glNormal3f_( null,minus, null )
        glTexCoord2f_( one, one ) : glVertex3f_( minus,minus,minus )
        glTexCoord2f_( null,one ) : glVertex3f_(  one,minus,minus )
        glTexCoord2f_( null,null) : glVertex3f_(  one,minus, one )
        glTexCoord2f_( one, null ): glVertex3f_( minus,minus, one )
        ;' Right Face
        glNormal3f_( one, null, null )
        glTexCoord2f_( one, null ) : glVertex3f_(  one,minus,minus )
        glTexCoord2f_( one, one ) : glVertex3f_(  one, one,minus )
        glTexCoord2f_( null, one ) : glVertex3f_(  one, one, one )
        glTexCoord2f_( null, null ) : glVertex3f_(  one,minus, one )
        ;' Left Face
        glNormal3f_(minus, null, null )
        glTexCoord2f_( null, null ) : glVertex3f_( minus,minus,minus )
        glTexCoord2f_( one, null ) : glVertex3f_( minus,minus, one )
        glTexCoord2f_( one, one ) : glVertex3f_( minus, one, one )
        glTexCoord2f_( null, one ) : glVertex3f_( minus, one,minus )
    glEnd_()
EndProcedure


Procedure DrawCube()
;
; real DrawCube() : Works with fixed PureBasic 3.40...
;
    glBegin_(#GL_Quads)
        ;' Front Face
        glNormal3f_( 0.0, 0.0, 1.0 )
        glTexCoord2f_( 0.0, 0.0 ) : glVertex3f_( -1.0,-1.0, 1.0 )
        glTexCoord2f_( 1.0, 0.0 ) : glVertex3f_(  1.0,-1.0, 1.0 )
        glTexCoord2f_( 1.0, 1.0 ) : glVertex3f_(  1.0, 1.0, 1.0 )
        glTexCoord2f_( 0.0, 1.0 ) : glVertex3f_( -1.0, 1.0, 1.0 )
        ;' Back Face
        glNormal3f_( 0.0, 0.0,-1.0 )
        glTexCoord2f_( 1.0, 0.0 ) : glVertex3f_( -1.0,-1.0,-1.0 )
        glTexCoord2f_( 1.0, 1.0 ) : glVertex3f_( -1.0, 1.0,-1.0 )
        glTexCoord2f_( 0.0, 1.0 ) : glVertex3f_(  1.0, 1.0,-1.0 )
        glTexCoord2f_( 0.0, 0.0 ) : glVertex3f_(  1.0,-1.0,-1.0 )
        ;' Top Face
        glNormal3f_( 0.0, 1.0, 0.0 )
        glTexCoord2f_( 0.0, 1.0 ) : glVertex3f_( -1.0, 1.0,-1.0 )
        glTexCoord2f_( 0.0, 0.0 ) : glVertex3f_( -1.0, 1.0, 1.0 )
        glTexCoord2f_( 1.0, 0.0 ) : glVertex3f_(  1.0, 1.0, 1.0 )
        glTexCoord2f_( 1.0, 1.0 ) : glVertex3f_(  1.0, 1.0,-1.0 )
        ;' Bottom Face
        glNormal3f_( 0.0,-1.0, 0.0 )
        glTexCoord2f_( 1.0, 1.0 ) : glVertex3f_( -1.0,-1.0,-1.0 )
        glTexCoord2f_( 0.0, 1.0 ) : glVertex3f_(  1.0,-1.0,-1.0 )
        glTexCoord2f_( 0.0, 0.0 ) : glVertex3f_(  1.0,-1.0, 1.0 )
        glTexCoord2f_( 1.0, 0.0 ) : glVertex3f_( -1.0,-1.0, 1.0 )
        ;' Right Face
        glNormal3f_( 1.0, 0.0, 0.0 )
        glTexCoord2f_( 1.0, 0.0 ) : glVertex3f_(  1.0,-1.0,-1.0 )
        glTexCoord2f_( 1.0, 1.0 ) : glVertex3f_(  1.0, 1.0,-1.0 )
        glTexCoord2f_( 0.0, 1.0 ) : glVertex3f_(  1.0, 1.0, 1.0 )
        glTexCoord2f_( 0.0, 0.0 ) : glVertex3f_(  1.0,-1.0, 1.0 )
        ;' Left Face
        glNormal3f_(-1.0, 0.0, 0.0 )
        glTexCoord2f_( 0.0, 0.0 ) : glVertex3f_( -1.0,-1.0,-1.0 )
        glTexCoord2f_( 1.0, 0.0 ) : glVertex3f_( -1.0,-1.0, 1.0 )
        glTexCoord2f_( 1.0, 1.0 ) : glVertex3f_( -1.0, 1.0, 1.0 )
        glTexCoord2f_( 0.0, 1.0 ) : glVertex3f_( -1.0, 1.0,-1.0 )
    glEnd_()
EndProcedure


Procedure WindowResizeManager(Window,Message,wParam, lParam)
Result = #PB_ProcessPureBasicEvents 
If Message = #WM_SIZE And Window = OpenGLview_MainWnd
   newWidth = lParam & $FFFF
   newHeight = (lParam >> 16) & $FFFF
   MoveWindow_(OpenGLview_GadgetWin,newWidth-72,-1,74,newHeight+2,#TRUE)
   MoveWindow_(OpenGLview_subWnd,0,0,newWidth-70,newHeight,#TRUE)
   ReSizeGLScene(newWidth-70,newHeight)
   Result = 0
EndIf
ProcedureReturn Result 
EndProcedure

   
; ExecutableFormat=Windows
; Executable=PureGL.exe
; DisableDebugger