
;---------------------------------------------
;	 GLU32F - PureBasic Library V1.00
;=============================================
;	    Written by Roger Beausoleil
;	      visionfx@satelcom.qc.ca
;---------------------------------------------

;---------------------------------------------
;	PureBasic Functions Declarations
;---------------------------------------------
GLOBAL	PB_gluCylinderf_
GLOBAL	PB_gluDiskf_
GLOBAL	PB_gluLookAtf_
GLOBAL	PB_gluOrtho2Df_
GLOBAL	PB_gluPartialDiskf_
GLOBAL	PB_gluPerspectivef_ 
GLOBAL	PB_gluPickMatrixf_
GLOBAL	PB_gluProjectf_
GLOBAL	PB_gluSpheref_
GLOBAL	PB_gluUnProjectf_

;---------------------------------------------
;	External Functions Call
;---------------------------------------------
EXTERN	_gluCylinder@36				;-
EXTERN	_gluDisk@28					;-
EXTERN	_gluLookAt@72				;-
EXTERN	_gluOrtho2D@32				;-
EXTERN	_gluPartialDisk@44			;-
EXTERN	_gluPerspective@32			;- 
EXTERN	_gluPickMatrix@36				;-
EXTERN	_gluProject@48				;-
EXTERN	_gluSphere@20				;-
EXTERN	_gluUnProject@48				;-

;---------------------------------------------
;	The Pure Code
;---------------------------------------------

SEGMENT	.text	USE32	CLASS=CODE

PB_gluCylinderf_:
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float01 ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		CALL		SetFloat01InStack
		PUSH		Dword Eax
		CALL		_gluCylinder@36
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluDiskf_:
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float01 ]
		POP		Dword [ Float02 ]
		CALL		SetFloat02InStack
		CALL		SetFloat01InStack
		PUSH		Dword Eax
		CALL		_gluDisk@28
		PUSH		Dword [ ReturnAddr ] 
		RET

PB_gluLookAtf_:
		FST		Qword [ Float01 ]
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		POP		Dword [ Float05 ]
		POP		Dword [ Float06 ]
		POP		Dword [ Float07 ]
		POP		Dword [ Float08 ]
		POP		Dword [ Float09 ]
		CALL		SetFloat09InStack
		CALL		SetFloat08InStack
		CALL		SetFloat07InStack
		CALL		SetFloat06InStack
		CALL		SetFloat05InStack
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		CALL		_gluLookAt@72
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluOrtho2Df_:
		FST		Qword [ Float01 ]
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		CALL		_gluOrtho2D@32
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluPartialDiskf_:
		POP		Dword [ ReturnAddr ]
		MOV		Dword [ FirstArgument ],Eax
		POP		Dword [ Float01 ]
		POP		Dword [ Float02 ]
		POP		Dword Eax
		POP		Dword Ebx
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		PUSH		Dword Ebx
		PUSH		Dword Eax
		CALL		SetFloat02InStack
		CALL		SetFloat01InStack
		PUSH		Dword [ FirstArgument ]
		CALL		_gluPartialDisk@44
		PUSH		Dword [ ReturnAddr ]
		RET
		
PB_gluPerspectivef_:
		FST		Qword [ Float01 ]
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		CALL		_gluPerspective@32
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluPickMatrixf_:
		FST		Qword [ Float01 ]
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		CALL		_gluPickMatrix@36
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluProjectf_:
		FST		Qword [ Float01 ]
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		POP		Dword [ Float05 ]
		POP		Dword Eax
		POP		Dword [ Float06 ]
		POP		Dword [ Float07 ]
		POP		Dword [ Float08 ]
		CALL		SetFloat08InStack
		CALL		SetFloat07InStack
		CALL		SetFloat06InStack
		PUSH		Dword Eax
		CALL		SetFloat05InStack
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		CALL		_gluProject@48
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluSpheref_:
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float01 ]
		CALL		SetFloat01InStack
		PUSH		Dword Eax
		CALL		_gluSphere@20
		PUSH		Dword [ ReturnAddr ]
		RET

PB_gluUnProjectf_:
		FST		Qword [ Float01 ]
		POP		Dword [ ReturnAddr ]
		POP		Dword [ Float02 ]
		POP		Dword [ Float03 ]
		POP		Dword [ Float04 ]
		POP		Dword [ Float05 ]
		POP		Dword Eax
		POP		Dword [ Float06 ]
		POP		Dword [ Float07 ]
		POP		Dword [ Float08 ]
		CALL		SetFloat08InStack
		CALL		SetFloat07InStack
		CALL		SetFloat06InStack
		PUSH		Dword Eax
		CALL		SetFloat05InStack
		CALL		SetFloat04InStack
		CALL		SetFloat03InStack
		CALL		SetFloat02InStack
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		CALL		_gluUnProject@48
		PUSH		Dword [ ReturnAddr ]
		RET

SetFloat09InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float09 ]
		FST		Qword [ Float09 ]
		PUSH		Dword [ Float09 + 4 ]
		PUSH		Dword [ Float09 ]
		PUSH		Dword [ FunctionReturn ]
		RET
SetFloat08InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float08 ]
		FST		Qword [ Float08 ]
		PUSH		Dword [ Float08 + 4 ]
		PUSH		Dword [ Float08 ]
		PUSH		Dword [ FunctionReturn ]
		RET
SetFloat07InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float07 ]
		FST		Qword [ Float07 ]
		PUSH		Dword [ Float07 + 4 ]
		PUSH		Dword [ Float07 ]
		PUSH		Dword [ FunctionReturn ]
		RET
		
SetFloat06InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float06 ]
		FST		Qword [ Float06 ]
		PUSH		Dword [ Float06 + 4 ]
		PUSH		Dword [ Float06 ]
		PUSH		Dword [ FunctionReturn ]
		RET
SetFloat05InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float05 ]
		FST		Qword [ Float05 ]
		PUSH		Dword [ Float05 + 4 ]
		PUSH		Dword [ Float05 ]
		PUSH		Dword [ FunctionReturn ]
		RET
SetFloat04InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float04 ]
		FST		Qword [ Float04 ]
		PUSH		Dword [ Float04 + 4 ]
		PUSH		Dword [ Float04 ]
		PUSH		Dword [ FunctionReturn ]
		RET

SetFloat03InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float03 ]
		FST		Qword [ Float03 ]
		PUSH		Dword [ Float03 + 4 ]
		PUSH		Dword [ Float03 ]
		PUSH		Dword [ FunctionReturn ]
		RET
SetFloat02InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float02 ]
		FST		Qword [ Float02 ]
		PUSH		Dword [ Float02 + 4 ]
		PUSH		Dword [ Float02 ]
		PUSH		Dword [ FunctionReturn ]
		RET
SetFloat01InStack:
		POP		Dword [ FunctionReturn ]
		FINIT
		FLD		Dword [ Float01 ]
		FST		Qword [ Float01 ]
		PUSH		Dword [ Float01 + 4 ]
		PUSH		Dword [ Float01 ]
		PUSH		Dword [ FunctionReturn ]
		RET

	

;---------------------------------------------
;	Variable Declarations
;---------------------------------------------

SEGMENT	.data	CLASS=DATA
Float01		:	dd	0,0
Float02		:	dd	0,0
Float03		:	dd	0,0
Float04		:	dd	0,0
Float05		:	dd	0,0
Float06		:	dd	0,0
Float07		:	dd	0,0
Float08		:	dd	0,0
Float09		:	dd	0,0

ReturnAddr		:	dd	0
FunctionReturn	:	dd	0
FirstArgument	:	dd	0