;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |
;   $ Sprite laden               $                                 
;   $(C) by Bluespeed            $
;   $ bluespeedde@yahoo.de       $
;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |




;  --------------------------------------------------------------------
;              WAS WAERE EIN SPIEL OHNE BILDER ?
;  --------------------------------------------------------------------

;  Hallo und Willkommen zum 5. Teil der Tutorial Reihe von Purebasic. Heute wollen wir mit Purebasic ein Sprite laden.
;  Nun stellt sich die Frage: Was ist ein Sprite ueberhaupt? Das Wort Sprite heisst nichts anderes als Bild. Nur wird in der 
;  Spieleprogrammierung das Bild als Sprite bezeichnet. Ohne diese Sprites wuerden Spiele gar nicht nicht existieren, 
;  oder habt ihr schonmal ein Spiel ohne Bilder gesehen ;). Dies ist in Purebasic auch sehr einfach (alles ist in Purebasic sehr
;  einfach ^_^ ). Zu den letzten Tutorials kommen noch 3 Befehle dazu, um in Purebasic ein Bild in der Groesse von 35*35 zu laden.
;  Wenig oder?  NEIN! Es ist nicht wenig und es stimmt auch nicht. Man braucht lediglich nur 3 befehle + das vorherige Tutorial,  
;  um das Bild anzuzeigen. Genug gequasselt, jetzt fangen wir an:


; Wir muessen vorher noch etwas initialisieren, da wir ein Vollbild erstellen und dies braucht DirectX.
If InitSprite() = 0                                               ; Wenn wir die Sprite Funktion nicht initialisieren koennen,
  MessageRequester("Fehler","Konnte dx nicht finden",0)           ; wird ein Fehler gemeldet, der die moegliche Ursache ausgibt.
EndIf                                                             ; Ende der Abfrage

; Nun wollen wir auch die Escape Taste benutzen. Das uebernimmt nun auch DirectX (DirectInput).
If InitKeyboard()=0                                               ; Wenn wir die Keyboard Funktion nicht initialisieren koennen,
  MessageRequester("Fehler","Konnte dx nicht finden",0)           ; wird ein Fehler gemeldet, der die moegliche Ursache ausgibt.
EndIf                                                             ; Ende der Abfrage

; Jetzt wollen wir den Vollbild Modus erstellen.
If OpenScreen(800,600,32,"Vollbild") = 0                          ; Wenn "Oeffne ein Vollbild" aus ist,
  MessageRequester("Fehler","Konnte kein Vollbild erstellen ",0)  ; wird eine Fehlermeldung ausgegeben.
EndIf                                                             ; Ende der Abfrage

LoadSprite(0,"files\sprite.bmp",0)                                ; Wir laden das Sprite (Bild).

Repeat                                                  ; In der Schleife werden die ganzen Aktionen durchgefuehrt...
  FlipBuffers()                                         ; Wir flippen den Buffer.
  ClearScreen(255,0,0)                                  ; Wir "Saeubern" den Screen mit einer roten Farbe.
  ExamineKeyboard()                                     ; Um Keyboard Tasten funktionstuechtig zu machen, MUSS diese Funktion davor stehen.
  DisplaySprite(0,100,100)                              ; Wir zeichnen ein ganz normales Sprite.
  DisplayTransparentSprite(0,400,100)                   ; Wir zeichnen ein Sprite, das die Farbe schwarz als transparent anerkennt.
  If KeyboardPushed(#PB_Key_Escape)                     ; Wenn die Taste Escape gedrueckt wird,
    End                                                 ; wird das Programm beendet.
  EndIf                                                 ; Ende der Abfrage
ForEver                                                 ; Unendlicher Schleifen Durchlauf...
 
 
;  Das war es auch schon wieder :). Wir haben ein Bild geladen und es auf dem Screen angezeigt. Das eine Sprite, ist ein ganz normales
;  Sprite und das andere ist eins, das die Farbe schwarz (Farbcode: 0,0,0) als transparent anerkennt. Da waeren aber nohc ein paar Befehle
;  zu klaeren. Hier sind sie:

;  - LoadSprite(ID,Filename,Modus):
;    LoadSprite heisst auf deutsch "LadeSprite". Damit ist das klar, nun kommen die weiteren Eigenschaften: Die erste Angabe ist die ID,
;    es verhaelt sich hier genauso wie beim Fenster. Das zuerst geladene Bild bekommt - wenn man logisch sortiert - die ID 0, das zweite
;    geladene Bild die 1, das Dritte die 2, das Vierte die 3, das Fuenfte die 4 usw. Diese ID dient dazu, die Bilder unterscheiden zu
;    koennen. Die zweite Angabe dient zum Laden des Bildes aus einem Ordner.
;    Die dritte Angabe ist fuer den Modus da. Der 'Modus' Parameter kann folgende Werte annehmen:
;    0                : Normaler Modus, das Sprite befindet sich im Video-Speicher.
;    #PB_MemorySprite : Das Sprite wird in den PC-Hauptspeicher geladen (fuer Spezial-FX).
;    #PB_AlphaSprite  : Das Sprite ist 8 Bit, grau und wird mit DisplayAlphaSprite() oder DisplayShadowSprite() benutzt.

;  - Flipbuffers():
;    Purebasic benutzt DoubleBuffering. Nun gut, was sagt uns das aber? Um das zu verstehen, muessen wir uns Buffering erstmal genauer
;    ansehen. Man muss sich Doublebuffering als zwei Oberflaechen vorstellen: in der Ersten werden die ganzen Sachen geladen. Diese flippt
;    man um das geladene Bild zu sehen, wahrend man in der anderen etwas anderes laedt. DoubleBuffering nicht zu benutzen, ist in der
;    Spieleprogrammierung undenkbar. Denn ohne Doublebuffering wuerde das ganze Bild ganz stark ruckeln und nicht sehr fluessig ablaufen.

;  - DisplaySprite(ID,x,y) / DisplayTransparentSprite(ID,x,y):
;    Die beiden sind eigentlich gleich, ausser dass bei DisplayTransparentSprite die Farbe schwarz(0,0,0) als transparent anerkannt wird.
;    Der erste wert dient dazu, die die geladene ID von LoadSprite(ID,...) zu benutzen. Der zweite und der dritte Wert geben die Positionen
;    an (x,y).

;  Kompiliert den Code und staunt. Wir haben es geschafft, unser erstes Bildchen auf den Screen zu bringen *juhu
;  Das war es fuer heute, morgen werden wir die ganze Sache bewegen und auf den Bildschirm eingrenzen.

; CU
; BLUESPEED
    
; ExecutableFormat=Windows
; Executable=D:\Numan\Projekte\Tutorials\Tutorial4.exe