;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |
;   $ Sprite Kollision           $                                 
;   $(C) by Bluespeed            $
;   $ bluespeedde@yahoo.de       $
;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |




;  --------------------------------------------------------------------------
;                  KOLLISION ZWISCHEN ZWEI BILDERN
;  --------------------------------------------------------------------------

;  Hallo und Willkommen zum 7. Teil der Tutorial Reihe von Purebasic. Heute wollen wir mit Purebasic eine Kollision zwichen zwei
;  Bildern programmieren. Manche von Euch werden sich jetzt fragen, was eine Kollision ist und warum das so wichtig ist ?
;  Eine Kollisionsabfrage dient dazu, um zu pruefen, ob zwei bilder sich beruehren. Z.B. wenn man mit einen Raumschiff auf einen 
;  Meteoriten schiesst, so muss die Kollisionsabfrage ueberpruefen, ob das Bild sich mit dem Schuss und das Bild sich mit den
;  Meteoriten berruehrt. Wenn dies der Fall ist, kann man einen Effekt einfuegen, wie z.B. eine Explosion.  
;  Es bedarf hierfuer lediglich nur 3 Befehle zusaetzlich zu den letzten Sourcecodes.

; Wir muessen vorher noch etwas initialisieren, da wir ein Vollbild erstellen und dies braucht DirectX.
If InitSprite() = 0                                               ; Wenn wir die Sprite Funktion nicht initialisieren koennen,
  MessageRequester("Fehler","Konnte dx nicht finden",0)           ; wird ein Fehler gemeldet, der die moegliche Ursache ausgibt.
EndIf                                                             ; Ende der Abfrage

; Nun wollen wir auch die Escape Taste benutzen. Das uebernimmt nun auch DirectX (DirectInput).
If InitKeyboard()=0                                               ; Wenn wir die Keyboard Funktion nicht initialisieren koennen,
  MessageRequester("Fehler","Konnte dx nicht finden",0)           ; wird ein Fehler gemeldet, der die moegliche Ursache ausgibt.
EndIf                                                             ; Ende der Abfrage

; Jetzt wollen wir den Vollbild Modus erstellen.
If OpenScreen(800,600,32,"Vollbild") = 0                          ; Wenn "Oeffne ein Vollbild" aus ist,
  MessageRequester("Fehler","Konnte kein Vollbild erstellen ",0)  ; wird eine Fehlermeldung ausgegeben.
EndIf                                                             ; Ende der Abfrage

LoadSprite(0,"files\sprite.bmp",0)                                ; Wir laden das Sprite (Bild).

position_x = 0
position_y = 0 

Repeat                                               ; In der Schleife werden die ganzen Aktionen durchgefuehrt...
  FlipBuffers()                                      ; Wir flippen den Buffer.
  ClearScreen(0,255,0)                               ; Wir "saeubern" den Screen mit einer gruenen Farbe.
  ExamineKeyboard()                                  ; Um Keyboard Tasten funktionstuechtig zu machen, MUSS diese Funktion davor stehen.

; ----------------------------- Keyboard Abfrage---------------------------------------------------
  If KeyboardPushed(#PB_Key_Right)                   ; Wenn die rechte Pfeiltaste gedrueckt wird,
    position_x + 5                                   ; erhoehen wir den Wert der position_x um 5. D.h. wir verschieben unser Sprite nach rechts.
    If position_x > 700                              ; Wenn position_x groesser als 700 ist - also ueber den Bildschirm Rand geht,
      position_x = 700                               ; stoppen wir das Sprite.
    EndIf                                            ; Ende der KeyboardPushed Abfrage.
  EndIf                                              ; Ende der Abgrenzungsabfrage.

  If KeyboardPushed(#PB_Key_Left)                    ; Wenn die linke Pfeiltaste gedrueckt wird,
    position_x  - 5                                  ; ziehen wir vom Wert der postion_x 5 ab. D.h. wir verschieben unser Sprite nach links.
    If position_x < 0                                ; Wenn position_x kleiner als 0 ist - also ueber den Bildschirm Rand geht,
      position_x = 0                                 ; stoppen wir das Sprite.
    EndIf                                            ; Ende der KeyboardPushed Abfrage.
  EndIf                                              ; Ende der Abgrenzungsabfrage.

  If KeyboardPushed(#PB_Key_Up)                      ; Wenn die obere Pfeiltaste gedrueckt wird,
    position_y  - 5                                  ; ziehen wir vom Wert der postion_y 5 ab. D.h. wir verschieben unser Sprite nach oben.
    If position_y < 0                                ; Wenn position_y kleiner als 0 ist - also ueber den Bildschirm Rand geht,
      position_y = 0                                 ; stoppen wir das Sprite.
    EndIf                                            ; Ende der KeyboardPushed Abfrage.
  EndIf                                              ; Ende der Abgrenzungsabfrage.

  If KeyboardPushed(#PB_Key_Down)                    ; Wenn die untere Pfeiltaste gedrueckt wird,
    position_y + 5                                   ; erhoehen wir den Wert der postion_x um 5. D.h. wir verschieben unser Sprite nach unten.
    If position_y > 500                              ; Wenn position_x groesser als 500 ist - also ueber den Bildschirm Rand geht,
      position_y = 500                               ; stoppen wir das Sprite.
    EndIf                                            ; Ende der KeyboardPushed Abfrage.
  EndIf                                              ; Ende der Abgrenzungsabfrage.
;----------------------ENDE DER KEYBOARD ABFRAGE--------------------------------------------------

  If SpriteCollision(0,position_x,position_y,0,200,200) = 1   ; Wenn eine Kollision zwischen den beiden Bildern stattfindet...
    StartDrawing(ScreenOutput())                              ; Wir wollen einen Text schreiben, dazu muessen wir den Ausgabekanal bestimmen.
    DrawText("KOLLISION")                                     ; Wir zeigen einen Text, der angibt, dass eine Kollision stattfindet.
    StopDrawing()
  EndIf

  DisplayTransparentSprite(0,200,200)                         ; Wir zeichnen ein Sprite auf der Position x=200 und y=200.
  DisplayTransparentSprite(0,position_x,position_y)           ; Wir zeichnen ein Sprite mit der Farbe schwarz als tranparent und uebergeben ihm die beiden Bewegungsvariablen.

  If KeyboardPushed(#PB_Key_Escape)                           ; Wenn die Taste Escape gedrueckt wird,
    End                                                       ; wird das Programm beendet.
  EndIf                                                       ; Ende der Abfrage
ForEver                                                       ; Unendlicher Schleifendurchlauf


;  Was hat sich nun an unserem Code veraendert bzw. was ist dazu gekommen? 
;  Alles was wir dazugeschrieben haben, waren diese paar laecherlichen Zeilen Code:


;   If SpriteCollision(0,position_x,position_y,0,200,200) = 1          
;   Wenn eine Kollision zwischen (0,position_x,position_y,0,200,200) stattfindet

;   StartDrawing(ScreenOutput())           
;   fangen wir mit dem Zeichnen

;   DrawText("KOLLISION")   
;   eines Textes an.                                                                           

;   StopDrawing()
;   Ende des Zeichnens

;   EndIf
;   Ende der Abfrage
  

; Die Funktion SpriteCollision(BildID,x,y,BildID,x2,y2) dient dazu, die Abfrage einer Kollision zu pruefen.
; In der ersten Angabe wird die ID des geladenen Bilds angegeben, in unserem Falle das erste Bild also 0.
; In den beiden x,y Angaben wird die Position des ersten Bilds uebermittelt. Da sich unser Bild bewegt,
; muessen wir auch die Bewegungsvariablen eintragen: position_x und postion_y. 
; Nun muessen wir das zweite Bild angeben. Da wir nur ein Bild geladen haben, aber dieses zweimal gezeichnet
; wurde, setzen wir hier die zweite 0 ein und geben die Position an (200,200). 
 
; Das wars mal wieder. Spielt ein bisschen mit dem Code rum und versucht mal eine Kollision an einer anderen
; Stelle auszufuehren.

; CU
; BLUESPEED   
; ExecutableFormat=Windows
; Executable=D:\Numan\Projekte\Tutorials\Tutorial6.exe