;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |
;   $ Sprite Animation           $                                 
;   $(C) by Bluespeed            $
;   $ bluespeedde@yahoo.de       $
;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |




;  --------------------------------------------------------------------------
;                        ANIMATION VON SPRITES
;  --------------------------------------------------------------------------

;  Hallo und Willkommen zum 8. Teil der Tutorial Reihe von Purebasic. Heute wollen wir eine Sprite Animation erstellen,
;  doch vorher muessen wir klaeren, was Sprite Animationen sind und wofuer man sie braucht. Eine Sprite Animtion besteht 
;  aus mehreren Bildern, auch Frames genannt, die hintereinander abgespielt werden. Mit dieser Technik ist fast alles moeglich,
;  vom einfachen Rotieren bis hin zu unglaublichen Spezialeffekten. Die Blitzbasic Programmierer werden sicher LoadAnimImage
;  kennen. Leider existiert in Purebasic kein direkter Befehl dafuer, aber es sind nur drei Zeilen Code die geschrieben werden 
;  muessen :). Wir fangen an:

; Wir muessen vorher noch etwas initialisieren, da wir ein Vollbild erstellen und dies braucht DirectX.
If InitSprite() = 0                                               ; Wenn wir die Sprite Funktion nicht initialisieren koennen,
  MessageRequester("Fehler","Konnte dx nicht finden",0)           ; wird ein Fehler gemeldet, der die moegliche Ursache ausgibt.
EndIf                                                             ; Ende der Abfrage

; Nun wollen wir auch die Escape Taste benutzen. Das uebernimmt nun auch DirectX (DirectInput).
If InitKeyboard()=0                                               ; Wenn wir die Keyboard Funktion nicht initialisieren koennen,
  MessageRequester("Fehler","Konnte dx nicht finden",0)           ; wird ein Fehler gemeldet, der die moegliche Ursache ausgibt.
EndIf                                                             ; Ende der Abfrage

; Jetzt wollen wir den Vollbild Modus erstellen.
If OpenScreen(800,600,32,"Vollbild") = 0                          ; Wenn "Oeffne ein Vollbild" aus ist,
  MessageRequester("Fehler","Konnte kein Vollbild erstellen ",0)  ; wird eine Fehlermeldung ausgegeben.
EndIf                                                             ; Ende der Abfrage

For anim = 1 To 16
  LoadSprite(anim,"files\anim_"+Str(anim)+".bmp",0)               ; Wir laden die 16 abgespeicherten BMP Einzelbilder mit der Animation
Next

anim = 1

Repeat                                               ; In der Schleife werden die ganzen Aktionen durchgefuehrt...
  ClearScreen(0,0,0)                                 ; Wir "saeubern" den Screen mit einer schwarzen Farbe.
  anim + 1                                           ; Wir erhoehen die Variable um 1, d.h. wir verschieben den "Strich" um ein Bild.
  If anim = 16                                       ; Wenn der Strich bei 16 angekommen ist,
    anim = 1                                         ; setzen wir ihn wieder auf 1.
  EndIf                                              ; Ende der Abfrage
  If anim = 1                                        ; Wenn die Variable anim auf 1 steht,
    anim + 1                                         ; erhoehen wir wieder das ganze um 1. 
  EndIf

  DisplayTransparentSprite(anim,30,30)               ; Wir zeichnen die Animtion (Bilder) anim auf der Position x= 30 Pixel und y= 30 Pixel.
  FlipBuffers()                                      ; Wir flippen den Buffer.
  ExamineKeyboard()                                  ; Um Keyboard Tasten funktionstuechtig zu machen, MUSS diese Funktion davor stehen.

  If KeyboardPushed(#PB_Key_Escape)                  ; Wenn die Taste Escape gedrueckt wird,
    End                                              ; wird das Programm beendet.
  EndIf                                              ; Ende der Abfrage
ForEver                                              ; Unendlicher Schleifendurchlauf


; Uns interessieren eigentlich nur die neuen 3 Zeilen Code, was soll das Ganze mit FOR NEXT? 
; Dies ist eine Schleife anderer Art. Sie dient dazu, um mehrere einzelne Dateien in einem Schleifendurchgang zu laden oder auch anzuzeigen.
; Die Variable anim wird jeweils um 1 erhoeht, um die Bilder 1 - 16 zu laden, mit Next wird die Schleife beendet. Der Str() Befehl wandelt
; Strings, also Zeichen, in Zahlen um. Das heisst anim von 1-16 laedt eigentlich folgendes: 
; LoadSprite(1,"files\anim_1.bmp",0) 
; LoadSprite(2,"files\anim_2.bmp",0)
; LoadSprite(3,"files\anim_3.bmp",0)
; LoadSprite(4,"files\anim_4.bmp",0)
; LoadSprite(5,"files\anim_5.bmp",0) usw.
; Auf diese Weise kann man mehrere Bilder in einer Varibale als ein Bild "zusammenschweissen". 

; Kommen wir nun zu den unteren 7 neuen Zeilen Code. Bevor wir das erklaeren, muessen wir erst wissen, was genau "anim" fuer eine rolle
; spielt:
; - Ich glaube das jeder von Euch schonmal den Windows-Medienplayer oder irgendeinen anderen Player gesehen hat. Unter den Playern ist
;   ein Balken mit einem kleinen Strich der durch Bewegungen anzeigt, wieviele Minuten/Stunden ein Mp3 oder DVD etc. noch braucht bis es
;   zu Ende ist. So koennt ihr Euch auch die Variable "anim" vorstellen. Ein Player, der mit einem Strich "anim + 1" die Bilder anzeigt.
;   Oder wie es auch die Profis nennen: die Frames werden so angezeigt.

; Hier die Uebersetzung der 7 Zeilen Code ins Deutsche:

;  anim um eins erhoehen
;  Wenn anim beim letzten Frame (Bild) angekommen ist,
;  setzt du es wieder auf eins.
;  Ende der Abfrage
;  Wenn anim wieder am Anfang ist,
;  erhoehst du es wieder um eins.
;  Ende der Abfrage

; Dieser Code verursacht einen unendlichen Durchlauf des Strichs, bis man die Taste Escape drueckt.
; Natuerlich muesst ihr nicht unbedingt die Variable anim nehmen, es bleibt an euch, wie ihr eure Animationen nennt.
; Nur wuerde ich einen eindeutigen Varibalen-Namen fuer die jeweiligen Animtionen empfehlen, z.B. wuerde eine
; Rotations-Animation schlecht als Explosion bezeichnet werden. 

; Und wir sind wieder einmal am Ende des Tutorials, morgen werden wir uns mit dem Musik und Sound abspielen in Purebasic
; beschaeftigen.  
; Bis dahin KEEP CODING

; cu
; bluespeed
 
 
; ExecutableFormat=Windows
; Executable=D:\Numan\Projekte\Tutorials\Tutorial7.exe