;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |
;   $ Sound/Musik                $                                 
;   $(C) by Bluespeed            $
;   $ bluespeedde@yahoo.de       $
;   |_-_-_-_-_-_-_-_-_-_-_-_-_-_ |




;  ---------------------------------------------------------------------------------
;                          SOUND UND MUSIK ABSPIELEN
;  ---------------------------------------------------------------------------------

;  Hallo und Willkommen zum 9. Teil der Tutorial Reihe von Purebasic. Heute wollen wir versuchen,
;  Sound mit einer Taste wiederzugeben, waehrend im Hintergrund Musik gespielt wird. In der Spiele-
;  programmierung setzt man einen Unterschied zwischen Musik und Sound, deshalb gibt es dafuer auch
;  unterschiedliche Befehle. Denn der Sound wird im Vordergrund gespielt, waehrend die Musik im
;  Hintergund laeuft.


; Wir Initialisieren Musik/Video
If InitMovie()= 0                                              ; Wenn die Initialisierung = 0 Byte ist (AUS),
  MessageRequester("Fehler","Konnte Dx nicht finden",0)        ; wird eine Nachricht gesendet, in der eine Fehlermeldung steht.
EndIf                                                          ; Ende der Abfrage  

; Wir Initialisieren den Sound 
If InitSound(1) = 0                                            ; Wenn die Initialisierung = 0 Byte ist (AUS),
  MessageRequester("Fehler","Konnte Dx nicht finden",0)        ; wird eine Nachricht gesendet, in der eine Fehlermeldung steht.
EndIf                                                          ; Ende der Abfrage

; Wir Initialisieren den Vollbild/Grafiken 
If InitSprite()= 0                                             ; Wenn die Initialisierung = 0 Byte ist (AUS),
  MessageRequester("Fehler","Konnte Dx nicht finden",0)        ; wird eine Nachricht gesendet, in der eine Fehlermeldung steht.
EndIf                                                          ; Ende der Abfrage

; Wir Initialisieren die Tastatur
If InitKeyboard() = 0                                          ; Wenn die Initialisierung = 0 Byte ist (AUS),
  MessageRequester("Fehler","Konnte Dx nicht finden",0)        ; wird eine Nachricht gesendet, in der eine Fehlermeldung steht.
EndIf                                                          ; Ende der Abfrage


; Wir oeffnen ein Vollbild, natuerlich wuerde es auch
; im Fenstermodus klappen.
If OpenScreen(800,600,32,"SOUND/MUSIK") = 0                    ; Wenn "Oeffne fenster" AUS (fehlgeschlagen) ist,
  MessageRequester("Fehler","Konnte kein Vollbild oeffnen",0)  ; wird eine Nachricht gesendet, in der eine Fehlermeldung steht.
EndIf                                                          ; Ende der Abfrage

LoadSound(0,"files\flush.wav")                   ; Wir laden die Sound-Datei. Die erste Angabe ist die ID, genau wie bei LoadSprite.
LoadMovie(0,"files\we.mid")                      ; Wir laden die Musik-Datei. Die erste Angabe ist die ID, genau wie bei LoadSprite.

sound = 0                                        ; Wir setzen eine Sound Variable, die AUS ist (Taste).

PlayMovie(0,0)                                   ; Musik wird abgespielt. 

Repeat                                           ; Starten der Repeat-Schleife
  ExamineKeyboard()                              ; Ohne diesen Befehl koennen wir keine Tastatur-Tasten benutzen.

  If KeyboardPushed(#PB_Key_Space)               ; Wenn Space (Leertaste) gedrueckt wird,
    sound = 1                                    ; ist der sound = AN (1 Byte)
  Else                                           ; anderenfalls
    sound = 0                                    ; ist der sound = Aus (0 Byte)
  EndIf                                          ; Ende der Abfrage 

  If sound = 1                                   ; Wenn sound = AN ist bzw. eine Taste gedrueckt wird,
    PlaySound(0,0)                               ; wird ein Sound abgespielt.
  EndIf                                          ; Ende der Abfrage 

  If KeyboardPushed(#PB_Key_Escape)              ; Wenn die Escape-Taste gedrueckt wird,
    End                                          ; wird das Programm beendet.
  EndIf                                          ; Ende der Abfrage
ForEver                                          ; unendliche Schleife

; Wir haben zwei neue Initialisierungen: einmal InitMovie() und ausserdem noch InitSound(). Da es in Purebasic keinen "richtigen"
; Befehl fuer Musik abspielen gibt, kann man ganz einfach die Movie Funktion dafuer nehmen. Es gibt keinen Unterschied zwischen
; einem "richtigen" Befehl oder dem "nicht direkten" Befehl von Purebasic. Ob man wie in BlitzBasic direkt PlayMusic() tippt oder
; mit Purebasic PlayMovie(): das Resultat ist das gleiche. Purebasic Programmierer haben sogar einen Vorteil: wenn wir einen Film
; oder Musik abspielen wollen, muessen wir nur LoadMovie() und PlayMoive() einsetzen. So hat man die Musik und Film/Video Funktionen
; in zwei Befehlen :) (LoadMovie(),PlayMovie()).
; InitSound() muss vor den LoadSound und PlaySound Befehlen kommen, das ist genau so wie bei InitSprite oder InitKeyboard.
; Hier mal eine kurze Liste ueber die wichtigsten Initialisierungen fuer ein Spiel:

; - InitSprite()   (Um ein Vollbild zu erstellen und auch um die Grafiken anzuzeigen)
; - InitKeyboard() (Um die Tastatur Befehle zu benutzen)
; - InitMouse()    (Um die Maus Befehle zu benutzen )
; - InitJoystick() (Um die Joystick Befehle zu benutzen)
; - InitMovie()    (Um die Film- oder Musik Befehle zu benutzen)
; - InitSound()    (Um Sound (Geraeusche) Befehle zu benutzen) 
; - InitNetwork()  (Um Netzwerk Befehle zu benutzen)

; Das sind nicht alle, aber die Wichtigsten fuer die Spieleprogrammierung. Kommen wir zu InitSound zurueck: in dem InitSound()
; Befehl steht eine Zahl. Diese dient dazu, um anzugeben, wieviele Sounds (Geraeusche) man laden moechte. Da wir nur eins haben,
; setzen wir einfach die 0 dahin (in der Purebasic Programmierung ist die 0 die erste Zahl). Zum Laden und Abspielen brauche ich
; wohl nichts weiter zu sagen, ausser dass Musik nicht in einer Schleife abgespielt werden kann. Denn sonst wuerde sie sich immer
; wiederholen. Nun wollen wir uns mit der Leertastenabfrage beschaeftigen:
  
; If KeyboardPushed(#PB_Key_Space)                             
;   sound = 1                                                     
; Else                                                       
;   sound = 0                                                      
; EndIf  

; If sound = 1                                                 
;   PlaySound(0,0)                                                 
; EndIf                                                         


; Ich werde es erstmal uebersetzen:

; Wenn die Leertaste gedrueckt wird,
; ist die Variable sound An
; anderenfalls
; ist die Varibale sound Aus.
; Ende der Abfrage

; Wenn die Variable sound An ist,
; spiele den geladenen Sound ab.
; Ende der Abfrage


; Ihr fragt euch sicherlich, wozu das Ganze da ist. Warum koennte man nicht einfach

; If KeyboardPushed(#PB_Key_Space)                             
;   PlaySound(0,0)                                                      
; EndIf   

; benutzen? 

; Dies wuerde zu einer staendigen Wiederholung des Soundes fuehren, da er ja in einer Schleife ablaeuft. Deshalb muessen 
; wir erstmal mit Hilfe einer Variable, die Ihr euch als Taste von eurem Recorder vorstellen koennt, eine Abfrage machen.
; Ich koennte auch anstelle Variable oben Taste schreiben, aber das waere ja nicht 100% korrekt, da wir uns die Variable
; nur als Taste vorstellen sollten.

; So, das war's fuer heute und eigentlich waert ihr jetzt imstande EIN SPIEL in Purebasic zu programmieren. Morgen werden 
; wir uns mal die zur Verfuegung gestellten Effekte von PB ansehen.

; Bis dahin fleissig ueben ;)

; CU 
; BLUESPEED
   
; ExecutableFormat=Windows
; Executable=D:\Numan\Projekte\Tutorials\Tutorial8.exe